/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.data.Field;
import com.aliyun.datahub.common.data.FieldType;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.model.Record;
import java.math.BigDecimal;
import java.util.HashMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class RecordEntry
extends Record {
    private Field[] fields;
    private Object[] values;
    private HashMap<String, Integer> nameMap = new HashMap();

    public RecordEntry(RecordSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema must not be null");
        }
        this.init(schema.getFields().toArray(new Field[0]));
    }

    public RecordEntry(Field[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields list must not be null");
        }
        this.init(fields);
    }

    private void init(Field[] fields) {
        this.fields = fields;
        this.values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.nameMap.put(fields[i].getName(), i);
        }
    }

    @Override
    public long getRecordSize() {
        long len = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            Field field = this.fields[i];
            if (field.getType() == FieldType.BIGINT) {
                len += 8L;
                continue;
            }
            if (field.getType() == FieldType.BOOLEAN) {
                len += 4L;
                continue;
            }
            if (field.getType() == FieldType.DOUBLE) {
                len += 8L;
                continue;
            }
            if (field.getType() == FieldType.TIMESTAMP) {
                len += 8L;
                continue;
            }
            if (field.getType() == FieldType.STRING) {
                len += (long)((String)this.values[i]).length();
                continue;
            }
            if (field.getType() == FieldType.DECIMAL) {
                len += (long)((BigDecimal)this.values[i]).toPlainString().length();
                continue;
            }
            throw new IllegalArgumentException("unknown record type :" + field.getType().name());
        }
        return len;
    }

    public int getFieldCount() {
        return this.values.length;
    }

    public Field[] getFields() {
        return this.fields;
    }

    private Object get(int idx) {
        return this.values[idx];
    }

    private Object get(String fieldName) {
        return this.values[this.getFieldIndex(fieldName)];
    }

    public void setBigint(int idx, Long value) {
        if (value != null && (value > Long.MAX_VALUE || value <= Long.MIN_VALUE)) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
        this.values[idx] = value;
    }

    public Long getBigint(int idx) {
        return (Long)this.get(idx);
    }

    public void setBigint(String fieldName, Long value) {
        this.setBigint(this.getFieldIndex(fieldName), value);
    }

    public Long getBigint(String fieldName) {
        return (Long)this.get(fieldName);
    }

    public void setDouble(int idx, Double value) {
        this.values[idx] = value;
    }

    public Double getDouble(int idx) {
        return (Double)this.get(idx);
    }

    public void setDouble(String fieldName, Double value) {
        this.setDouble(this.getFieldIndex(fieldName), value);
    }

    public Double getDouble(String fieldName) {
        return (Double)this.get(fieldName);
    }

    public void setBoolean(int idx, Boolean value) {
        this.values[idx] = value;
    }

    public Boolean getBoolean(int idx) {
        return (Boolean)this.get(idx);
    }

    public void setBoolean(String fieldName, Boolean value) {
        this.setBoolean(this.getFieldIndex(fieldName), value);
    }

    public Boolean getBoolean(String fieldName) {
        return (Boolean)this.get(fieldName);
    }

    public void setTimeStamp(int idx, Long microseconds) {
        if (microseconds != null && (microseconds > Long.MAX_VALUE || microseconds <= Long.MIN_VALUE)) {
            throw new IllegalArgumentException("InvalidData: timestamp out of range.");
        }
        this.values[idx] = microseconds;
    }

    public Long getTimeStamp(int idx) {
        return (Long)this.get(idx);
    }

    public void setTimeStamp(String fieldName, Long microseconds) {
        this.setTimeStamp(this.getFieldIndex(fieldName), microseconds);
    }

    public Long getTimeStamp(String fieldName) {
        return (Long)this.get(fieldName);
    }

    public void setString(int idx, String value) {
        this.values[idx] = value;
    }

    public String getString(int idx) {
        Object o = this.get(idx);
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    public void setString(String fieldName, String value) {
        this.setString(this.getFieldIndex(fieldName), value);
    }

    public String getString(String fieldName) {
        return this.getString(this.getFieldIndex(fieldName));
    }

    public void setDecimal(int idx, BigDecimal value) {
        this.values[idx] = value;
    }

    public BigDecimal getDecimal(int idx) {
        Object o = this.get(idx);
        if (o == null) {
            return null;
        }
        return (BigDecimal)o;
    }

    public void setDecimal(String fieldName, BigDecimal value) {
        this.setDecimal(this.getFieldIndex(fieldName), value);
    }

    public BigDecimal getDecimal(String fieldName) {
        return this.getDecimal(this.getFieldIndex(fieldName));
    }

    public int getFieldIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Field name is null");
        }
        Integer idx = this.nameMap.get(name.toLowerCase());
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name.toLowerCase());
        }
        return idx;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = super.toObjectNode();
        ArrayNode record = node.putArray("Data");
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (this.get(i) != null) {
                if (this.fields[i].getType() == FieldType.DECIMAL) {
                    record.add(((BigDecimal)this.get(i)).toPlainString());
                    continue;
                }
                record.add(String.valueOf(this.get(i)));
                continue;
            }
            record.add((JsonNode)null);
        }
        return node;
    }
}

