/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.compress;

import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.compress.CompressionFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class Compression {
    public static byte[] compress(byte[] data, CompressionFormat compressionFormat) {
        if (compressionFormat.equals((Object)CompressionFormat.LZ4)) {
            return Compression.lz4Compress(data);
        }
        if (compressionFormat.equals((Object)CompressionFormat.ZLIB)) {
            try {
                return Compression.zlibCompress(data);
            }
            catch (IOException e) {
                throw new DatahubClientException(e.getMessage());
            }
        }
        throw new DatahubClientException("Unsupported compression format.");
    }

    public static byte[] decompress(byte[] compressed, CompressionFormat compressionFormat) {
        if (compressionFormat.equals((Object)CompressionFormat.LZ4)) {
            throw new DatahubClientException("raw size hint is missing.");
        }
        if (compressionFormat.equals((Object)CompressionFormat.ZLIB)) {
            try {
                return Compression.zlibDecompress(compressed);
            }
            catch (IOException e) {
                throw new DatahubClientException(e.getMessage());
            }
        }
        throw new DatahubClientException("Unsupported compression format.");
    }

    public static byte[] decompress(byte[] compressed, CompressionFormat compressionFormat, int rawSizeHint) {
        if (compressionFormat.equals((Object)CompressionFormat.LZ4)) {
            if (rawSizeHint <= 0) {
                throw new DatahubClientException("Raw size is invalied:" + rawSizeHint);
            }
            return Compression.lz4Decompress(compressed, rawSizeHint);
        }
        if (compressionFormat.equals((Object)CompressionFormat.ZLIB)) {
            try {
                return Compression.zlibDecompress(compressed);
            }
            catch (IOException e) {
                throw new DatahubClientException(e.getMessage());
            }
        }
        throw new DatahubClientException("Unsupported compression format.");
    }

    public static byte[] lz4Compress(byte[] dataToCompress) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        byte[] compressed = compressor.compress(dataToCompress);
        return compressed;
    }

    public static byte[] lz4Decompress(byte[] compressed, int len) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4SafeDecompressor decompressor = factory.safeDecompressor();
        byte[] restored = new byte[len];
        int size = decompressor.decompress(compressed, restored);
        restored = Arrays.copyOf(restored, size);
        return restored;
    }

    public static byte[] zlibCompress(byte[] dataToCompress) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(1);
        DeflaterOutputStream zlibStream = new DeflaterOutputStream((OutputStream)byteStream, deflater);
        zlibStream.write(dataToCompress);
        zlibStream.close();
        byteStream.close();
        byte[] compressedData = byteStream.toByteArray();
        return compressedData;
    }

    public static byte[] zlibDecompress(byte[] compressed) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        InflaterOutputStream zlibStream = new InflaterOutputStream(byteStream);
        zlibStream.write(compressed);
        zlibStream.close();
        byteStream.close();
        byte[] restored = byteStream.toByteArray();
        return restored;
    }
}

