/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.AppendFieldRequest;
import com.aliyun.datahub.model.serialize.Serializer;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class AppendFieldRequestJsonSer
implements Serializer<DefaultRequest, AppendFieldRequest> {
    private static AppendFieldRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(AppendFieldRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setHttpMethod(HttpMethod.POST);
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName());
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode body = mapper.createObjectNode();
        body.put("Action", "appendfield");
        body.put("FieldName", request.getField().getName());
        body.put("FieldType", request.getField().getType().toString());
        try {
            req.setBody(mapper.writeValueAsString((Object)body));
        }
        catch (IOException e) {
            throw new DatahubClientException("serialize error", e);
        }
        return req;
    }

    private AppendFieldRequestJsonSer() {
    }

    public static AppendFieldRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new AppendFieldRequestJsonSer();
        }
        return instance;
    }
}

