/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.CreateTopicRequest;
import com.aliyun.datahub.model.serialize.Serializer;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class CreateTopicRequestJsonSer
implements Serializer<DefaultRequest, CreateTopicRequest> {
    private static CreateTopicRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(CreateTopicRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName());
        req.setHttpMethod(HttpMethod.POST);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode body = mapper.createObjectNode();
        body.put("ShardCount", request.getShardCount());
        body.put("Lifecycle", request.getLifeCycle());
        body.put("RecordType", request.getRecordType().toString());
        if (request.getRecordSchema() != null) {
            body.put("RecordSchema", request.getRecordSchema().toJsonString());
        }
        body.put("Comment", request.getComment());
        try {
            req.setBody(mapper.writeValueAsString((Object)body));
        }
        catch (IOException e) {
            throw new DatahubClientException("serialize error", e);
        }
        return req;
    }

    private CreateTopicRequestJsonSer() {
    }

    public static CreateTopicRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new CreateTopicRequestJsonSer();
        }
        return instance;
    }
}

