/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.GetCursorRequest;
import com.aliyun.datahub.model.serialize.Serializer;

public class GetCursorRequestJsonSer
implements Serializer<DefaultRequest, GetCursorRequest> {
    private static GetCursorRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(GetCursorRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setHttpMethod(HttpMethod.POST);
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName() + "/shards/" + request.getShardId());
        String typeName = request.getType() == null ? "SYSTEM_TIME" : request.getType().toString();
        String timeFields = "";
        if (typeName.equals("SYSTEM_TIME")) {
            timeFields = ",\"SystemTime\":" + String.valueOf(request.getTimestamp());
        } else if (typeName.equals("SEQUENCE")) {
            timeFields = ",\"Sequence\":" + String.valueOf(request.getSequence());
        }
        String body = "{\"Action\":\"cursor\"" + timeFields + ",\"Type\":\"" + typeName + "\"}";
        req.setBody(body);
        return req;
    }

    private GetCursorRequestJsonSer() {
    }

    public static GetCursorRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new GetCursorRequestJsonSer();
        }
        return instance;
    }
}

