/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.GetSubscriptionRequest;
import com.aliyun.datahub.model.GetSubscriptionResult;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GetSubscriptionResultJsonDeser
implements Deserializer<GetSubscriptionResult, GetSubscriptionRequest, Response> {
    private static GetSubscriptionResultJsonDeser instance;

    @Override
    public GetSubscriptionResult deserialize(GetSubscriptionRequest request, Response response) throws DatahubServiceException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        GetSubscriptionResult rs = new GetSubscriptionResult();
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree(response.getBody());
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        rs.setIsOwner(tree.get("IsOwner").asBoolean());
        rs.setSubId(tree.get("SubId").asText());
        rs.setTopicName(tree.get("TopicName").asText());
        rs.setComment(tree.get("Comment").asText());
        rs.setCreateTime(tree.get("CreateTime").asLong() * 1000L);
        rs.setLastModifyTime(tree.get("LastModifyTime").asLong() * 1000L);
        return rs;
    }

    private GetSubscriptionResultJsonDeser() {
    }

    public static GetSubscriptionResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new GetSubscriptionResultJsonDeser();
        }
        return instance;
    }
}

