/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.QuerySubscriptionRequest;
import com.aliyun.datahub.model.serialize.Serializer;

public class QuerySubscriptionRequestJsonSer
implements Serializer<DefaultRequest, QuerySubscriptionRequest> {
    private static QuerySubscriptionRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(QuerySubscriptionRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setHttpMethod(HttpMethod.POST);
        req.setResource("/projects/" + request.getProjectName() + "/subscriptions");
        String body = "{\"Action\":\"list\"";
        if (request.getTopicName() != null) {
            body = body + ",\"TopicName\":\"" + request.getTopicName() + "\"";
        }
        if (request.getQueryKey() != null) {
            body = body + ",\"Search\":\"" + request.getQueryKey() + "\"";
        }
        body = body + ",\"PageIndex\":" + request.getPageIndex() + ",\"PageSize\":" + request.getPageSize();
        body = body + "}";
        req.setBody(body);
        return req;
    }

    private QuerySubscriptionRequestJsonSer() {
    }

    public static QuerySubscriptionRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new QuerySubscriptionRequestJsonSer();
        }
        return instance;
    }
}

