/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.InvalidParameterException;
import com.aliyun.datahub.model.UpdateConnectorShardContextRequest;
import com.aliyun.datahub.model.serialize.Serializer;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class UpdateConnectorShardContextRequestJsonSer
implements Serializer<DefaultRequest, UpdateConnectorShardContextRequest> {
    private static UpdateConnectorShardContextRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(UpdateConnectorShardContextRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName() + "/connectors/" + request.getConnectorType().toString().toLowerCase());
        req.setHttpMethod(HttpMethod.POST);
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("Action", "UpdateShardContext");
        node.put("ShardId", request.getShardContext().getShardId());
        if (request.getShardContext().getCurSequence() < 0L) {
            throw new InvalidParameterException("CurSequence is invalid.");
        }
        node.put("CurrentSequence", request.getShardContext().getCurSequence());
        if (request.getShardContext().getStartSequence() >= 0L) {
            node.put("StartSequence", request.getShardContext().getStartSequence());
        }
        if (request.getShardContext().getEndSequence() >= 0L) {
            node.put("EndSequence", request.getShardContext().getEndSequence());
        }
        try {
            req.setBody(mapper.writeValueAsString((Object)node));
        }
        catch (IOException e) {
            throw new DatahubClientException("serialize error", e);
        }
        return req;
    }

    private UpdateConnectorShardContextRequestJsonSer() {
    }

    public static UpdateConnectorShardContextRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new UpdateConnectorShardContextRequestJsonSer();
        }
        return instance;
    }
}

