/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.rest;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class JAXBUtils {
    private static final ThreadLocal<Map<String, JAXBContext>> threadLocal = new ThreadLocal<Map<String, JAXBContext>>(){

        @Override
        protected Map<String, JAXBContext> initialValue() {
            return new HashMap<String, JAXBContext>();
        }
    };

    public static <T> String marshal(T obj, Class<T> clazz) throws JAXBException {
        JAXBContext jc = JAXBUtils.getJAXBContext(clazz);
        Marshaller m = jc.createMarshaller();
        StringWriter out = new StringWriter();
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            CDATAXMLStreamWriter writer = new CDATAXMLStreamWriter(xof.createXMLStreamWriter(out));
            m.marshal(obj, (XMLStreamWriter)writer);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    public static <T> T unmarshal(byte[] xml, Class<T> clazz) throws JAXBException {
        if (xml == null) {
            throw new RuntimeException("Invalid XML to unmarshal.");
        }
        JAXBContext jc = JAXBUtils.getJAXBContext(clazz);
        Unmarshaller um = jc.createUnmarshaller();
        return (T)um.unmarshal((InputStream)new ByteArrayInputStream(xml));
    }

    public static <T> T unmarshal(Response resp, Class<T> clazz) throws JAXBException {
        if (resp == null || resp.getBody() == null) {
            throw new RuntimeException("Invalid XML to unmarshal.");
        }
        return JAXBUtils.unmarshal(resp.getBody(), clazz);
    }

    private static JAXBContext getJAXBContext(Class<?> clazz) throws JAXBException {
        Map<String, JAXBContext> cache = threadLocal.get();
        JAXBContext jc = cache.get(clazz.getName());
        if (jc == null) {
            jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            cache.put(clazz.getName(), jc);
        }
        return jc;
    }

    public static class DateBinding
    extends XmlAdapter<String, Date> {
        public String marshal(Date date) throws Exception {
            return DateUtils.formatRfc822Date(date);
        }

        public Date unmarshal(String date) throws Exception {
            return DateUtils.parseRfc822Date(date);
        }
    }

    private static class CDATAXMLStreamWriter
    implements XMLStreamWriter {
        private static final Pattern XML_CHARS = Pattern.compile("[&<>]");
        private XMLStreamWriter w;

        public CDATAXMLStreamWriter(XMLStreamWriter writer) {
            this.w = writer;
        }

        @Override
        public void close() throws XMLStreamException {
            this.w.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.w.flush();
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.w.getNamespaceContext();
        }

        @Override
        public String getPrefix(String uri) throws XMLStreamException {
            return this.w.getPrefix(uri);
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.w.getProperty(name);
        }

        @Override
        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.w.setDefaultNamespace(uri);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.w.setNamespaceContext(context);
        }

        @Override
        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.w.setPrefix(prefix, uri);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.w.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.w.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.w.writeAttribute(localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.w.writeCData(data);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.w.writeCharacters(new String(text, start, len));
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            boolean useCData = XML_CHARS.matcher(text).find();
            if (useCData) {
                this.w.writeCData(text);
            } else {
                this.w.writeCharacters(text);
            }
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.w.writeComment(data);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.w.writeDTD(dtd);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.w.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.w.writeEmptyElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.w.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.w.writeEmptyElement(localName);
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.w.writeEndDocument();
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.w.writeEndElement();
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.w.writeEntityRef(name);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.w.writeNamespace(prefix, namespaceURI);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.w.writeProcessingInstruction(target, data);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.w.writeProcessingInstruction(target);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            this.w.writeStartDocument();
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.w.writeStartDocument(encoding, version);
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            this.w.writeStartDocument(version);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.w.writeStartElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.w.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.w.writeStartElement(localName);
        }
    }
}

