/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.wrapper;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.common.data.RecordType;
import com.aliyun.datahub.model.GetProjectResult;
import com.aliyun.datahub.wrapper.Topic;
import java.util.List;

public class Project {
    private GetProjectResult data;
    private DatahubClient client;

    private Project(GetProjectResult data, DatahubClient client) {
        this.data = data;
        this.client = client;
    }

    public Topic createTopic(String topicName, int shardCount, int lifeCycle, RecordType recordType, RecordSchema recordSchema, String desc) {
        this.client.createTopic(this.data.getProjectName(), topicName, shardCount, lifeCycle, recordType, recordSchema, desc);
        return Topic.Builder.build(this.data.getProjectName(), topicName, this.client);
    }

    public List<String> listTopic() {
        return this.client.listTopic(this.data.getProjectName()).getTopics();
    }

    public Topic getTopic(String topicName) {
        return Topic.Builder.build(this.data.getProjectName(), topicName, this.client);
    }

    public void updateTopic(String topicName, int lifecycle, String desc) {
        this.client.updateTopic(this.data.getProjectName(), topicName, lifecycle, desc);
    }

    public void deleteTopic(String topicName) {
        this.client.deleteTopic(this.data.getProjectName(), topicName);
    }

    public String getComment() {
        return this.data.getComment();
    }

    public String getProjectName() {
        return this.data.getProjectName();
    }

    public long getCreateTime() {
        return this.data.getCreateTime();
    }

    public long getLastModifyTime() {
        return this.data.getLastModifyTime();
    }

    public static class Builder {
        public static Project build(String projectName, DatahubClient client) {
            return new Project(client.getProject(projectName), client);
        }

        public static Project build(String projectName, DatahubConfiguration conf) {
            DatahubClient client = new DatahubClient(conf);
            return Builder.build(projectName, client);
        }
    }
}

