/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common.security;

import java.util.Arrays;
import java.util.List;
import sun.security.util.SecurityConstants;

public class DefaultSecurityManager
extends SecurityManager {
    private final String[] blockedPropertyKey = new String[]{"java.endorsed.dirs", "java.class.path", "java.ext.dirs", "java.library.path", "java.security.policy", "java.securiy.manager", "java.vm.version", "os.version", "sun.boot.class.path", "sun.boot.library.path"};
    private final List<String> blockedPropertyKeys = Arrays.asList(this.blockedPropertyKey);

    @Override
    public void checkExit(int status) {
        super.checkExit(status);
        try {
            this.checkPermission(new RuntimePermission("odpsExitVM"));
        }
        catch (SecurityException e) {
            throw new SecurityException("ODPS-0730001: " + e.getMessage());
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        super.checkAccess(g);
        if (g == null) {
            throw new NullPointerException("ODPS-0730001: thread group can't be null");
        }
        try {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        catch (SecurityException e) {
            throw new SecurityException("ODPS-0730001: " + e.getMessage());
        }
    }

    @Override
    public void checkAccess(Thread t) {
        super.checkAccess(t);
        if (t == null) {
            throw new NullPointerException("ODPS-0730001: thread can't be null");
        }
        try {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        catch (SecurityException e) {
            throw new SecurityException("ODPS-0730001: " + e.getMessage());
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        super.checkPropertyAccess(key);
        if (this.blockedPropertyKeys.contains(key)) {
            try {
                this.checkPermission(new RuntimePermission("readSystemProperty"));
            }
            catch (SecurityException e) {
                throw new SecurityException("ODPS-0730001: " + e.getMessage());
            }
        }
    }
}

