/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.sqlgen;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.bridge.utils.TypeUtils;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SqlGenContext {
    private JobConf job;
    private String id;
    private static final String MULTIDEST_LABEL = "MULTIDEST_LABEL";
    private static final String INNEROUTPUT_LABEL = "INNEROUTPUT_LABEL";
    private static final String KEY_PREFIX = "k_";
    private static final String VALUE_PREFIX = "v_";
    private static final String PARTITION_ID = "__partition_id__";
    private Column[] packagedOutputSchema;
    private List<TableInfo> outputTableInfos = new ArrayList<TableInfo>();
    private Pipeline pipeline;
    private boolean pipeMode;

    public static String getMultidestLabel() {
        return MULTIDEST_LABEL;
    }

    public TableInfo[] getInputTableInfos() {
        TableInfo[] tableInfos = InputUtils.getTables((JobConf)this.job);
        if (tableInfos == null || tableInfos.length == 0) {
            return tableInfos;
        }
        for (TableInfo tableInfo : tableInfos) {
            Column[] columns;
            if (tableInfo.getTableName() == null || tableInfo.getProjectName() == null || (columns = ((BridgeJobConf)this.job).getInputSchema(tableInfo)) == null || columns.length <= 0) continue;
            tableInfo.setCols(SchemaUtils.getNames((Column[])columns));
        }
        return tableInfos;
    }

    public LinkedHashMap<TableInfo, List<String>> mergeTableInfos() {
        TableInfo[] tableInfos = this.getInputTableInfos();
        LinkedHashMap<TableInfo, List<String>> ret = new LinkedHashMap<TableInfo, List<String>>();
        if (tableInfos == null || tableInfos.length == 0) {
            return ret;
        }
        for (TableInfo tableInfo : tableInfos) {
            LinkedHashMap partSpec = tableInfo.getPartSpec();
            tableInfo.setPartSpec(new LinkedHashMap());
            tableInfo.setLable("__default__");
            String partStr = this.convertPartSpec(partSpec);
            List<String> partitions = ret.get(tableInfo);
            if (partitions == null) {
                partitions = new ArrayList<String>();
                ret.put(tableInfo, partitions);
            }
            if (partStr == null) continue;
            partitions.add(partStr);
        }
        return ret;
    }

    private String convertPartSpec(LinkedHashMap<String, String> partSpec) {
        if (partSpec == null || partSpec.size() == 0) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            ret.add(String.format("%s = \"%s\"", entry.getKey(), entry.getValue()));
        }
        return String.join((CharSequence)" AND ", ret);
    }

    public TableInfo[] getOutputTableInfos() {
        return OutputUtils.getTables((JobConf)this.job);
    }

    public boolean isNilOutput() {
        return OutputUtils.getTables((JobConf)this.job) == null;
    }

    public String getIntermediateColsJoined() {
        Column[] intermediateKeySchema = this.job.getMapOutputKeySchema();
        Column[] intermediateValueSchema = this.job.getMapOutputValueSchema();
        StringBuilder rt = new StringBuilder();
        if (intermediateKeySchema != null && intermediateKeySchema.length > 0) {
            for (String name : SchemaUtils.getNames((Column[])intermediateKeySchema)) {
                if (rt.length() > 0) {
                    rt.append(',');
                }
                rt.append(KEY_PREFIX + name);
            }
        }
        if (intermediateValueSchema != null && intermediateValueSchema.length > 0) {
            for (String name : SchemaUtils.getNames((Column[])intermediateValueSchema)) {
                if (rt.length() > 0) {
                    rt.append(',');
                }
                rt.append(VALUE_PREFIX + name);
            }
        }
        return rt.toString();
    }

    public String getIntermediateColsJoinedMapOut() {
        StringBuilder rt = new StringBuilder();
        if (this.job.getPartitionerClass() != null) {
            rt.append(PARTITION_ID);
            rt.append(',');
        }
        rt.append(this.getIntermediateColsJoined());
        return rt.toString();
    }

    private String getPrefixedJoinedString(String[] colList, String prefix) {
        StringBuilder sb = new StringBuilder();
        for (String s : colList) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(prefix).append(s);
        }
        return sb.toString();
    }

    public boolean mapOnly() {
        return this.pipeMode ? this.pipeline.getNodeNum() == 1 : this.job.getNumReduceTasks() == 0;
    }

    public String getPartitionColsJoined() {
        if (this.job.getPartitionerClass() != null) {
            return PARTITION_ID;
        }
        return this.getPrefixedJoinedString(this.job.getPartitionColumns(), KEY_PREFIX);
    }

    public String getSortColsJoined() {
        String[] cols = this.job.getOutputKeySortColumns();
        JobConf.SortOrder[] order = this.job.getOutputKeySortOrder();
        assert (cols.length == order.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cols.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(KEY_PREFIX).append(cols[i]).append(" ").append(order[i].toString());
        }
        return sb.toString();
    }

    public boolean multiInsert() {
        return this.getOutputTableInfos().length > 1;
    }

    public String getId() {
        return this.id;
    }

    public String getMapStreamProcessor() {
        String cmd = this.job.getStreamProcessor("map");
        if (cmd != null) {
            try {
                return URLDecoder.decode(cmd, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getReduceStreamProcessor() {
        String cmd = this.job.getStreamProcessor("reduce");
        if (cmd != null) {
            try {
                return URLDecoder.decode(cmd, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getFunctionCreateText() {
        return this.job.getFunctionCreateText();
    }

    public String getFunctionDropText() {
        return this.job.getFunctionDropText();
    }

    public List<TableInfo> getMultiOutputTableInfos() {
        return this.outputTableInfos;
    }

    public String getPackagedColsJoined() {
        if (this.outputTableInfos.isEmpty()) {
            this.initOutputSchema();
        }
        StringBuilder rt = new StringBuilder();
        if (this.packagedOutputSchema != null && this.packagedOutputSchema.length > 0) {
            for (String name : SchemaUtils.getNames((Column[])this.packagedOutputSchema)) {
                if (rt.length() > 0) {
                    rt.append(',');
                }
                rt.append(name);
            }
        }
        return rt.toString();
    }

    void initOutputSchema() {
        TableInfo[] tables = OutputUtils.getTables((JobConf)this.job);
        if (tables == null || tables.length == 0) {
            this.packagedOutputSchema = new Column[]{new Column("nil", OdpsType.STRING)};
            return;
        }
        if (tables.length == 1) {
            this.outputTableInfos.add(tables[0]);
            this.packagedOutputSchema = tables[0].getLabel() == null ? this.job.getOutputSchema() : this.job.getOutputSchema(tables[0].getLabel());
            return;
        }
        boolean innerOutput = this.job.getInnerOutputEnable();
        ArrayList<Column> outputColumns = new ArrayList<Column>();
        ArrayList<OdpsType> outputColumnTypes = new ArrayList<OdpsType>();
        HashMap<String, Integer> label2offset = new HashMap<String, Integer>();
        int length = 0;
        int tableIndex = 1;
        for (TableInfo t : tables) {
            Column[] tableCols;
            Column[] output = t.getLabel() == null ? this.job.getOutputSchema() : this.job.getOutputSchema(t.getLabel());
            ArrayList<Column> tableColumns = new ArrayList<Column>();
            ArrayList<OdpsType> tbColumnTypes = new ArrayList<OdpsType>();
            for (Column col : output) {
                tbColumnTypes.add(col.getType());
            }
            int idx = Collections.indexOfSubList(outputColumnTypes, tbColumnTypes);
            if (idx >= 0) {
                label2offset.put(t.getLabel(), idx);
                tableCols = new Column[output.length];
                tableColumns = new ArrayList(outputColumns.subList(idx, idx + output.length));
                tableColumns.toArray(tableCols);
                t.setCols(SchemaUtils.getNames((Column[])tableCols));
                this.outputTableInfos.add(t);
                continue;
            }
            label2offset.put(t.getLabel(), length);
            for (Column col : output) {
                outputColumnTypes.add(col.getType());
                String colName = String.format("output%d_%s", tableIndex, col.getName());
                tableColumns.add(TypeUtils.createColumnWithNewName(colName, col));
                outputColumns.add(TypeUtils.createColumnWithNewName(colName, col));
            }
            length += output.length;
            ++tableIndex;
            tableCols = new Column[tableColumns.size()];
            tableColumns.toArray(tableCols);
            t.setCols(SchemaUtils.getNames((Column[])tableCols));
            this.outputTableInfos.add(t);
        }
        Column[] outputFields = new Column[length += innerOutput ? 2 : 1];
        length = 0;
        Iterator iterator = outputColumns.iterator();
        while (iterator.hasNext()) {
            Column f;
            outputFields[length] = f = (Column)iterator.next();
            ++length;
        }
        outputFields[length] = new Column(MULTIDEST_LABEL, OdpsType.STRING);
        ++length;
        if (innerOutput) {
            outputFields[length] = new Column(INNEROUTPUT_LABEL, OdpsType.STRING);
        }
        this.packagedOutputSchema = outputFields;
    }

    public boolean isNoInputTableInfos() {
        return InputUtils.getTables((JobConf)this.job) == null;
    }

    public boolean isOutputOverwrite() {
        boolean isInnerOutput = this.job.getInnerOutputEnable();
        return isInnerOutput ? false : this.job.getOutputOverwrite();
    }

    public String getMapInputSeparator() {
        return this.getSeparator("map", "input");
    }

    public String getMapOutputSeparator() {
        return this.getSeparator("map", "output");
    }

    public String getReduceInputSeparator() {
        return this.getSeparator("reduce", "input");
    }

    public String getReduceOutputSeparator() {
        return this.getSeparator("reduce", "output");
    }

    String getSeparator(String taskType, String dataType) {
        String field = this.job.get(String.format("stream.%s.%s.field.separator", taskType, dataType));
        String record = this.job.get(String.format("stream.%s.%s.record.separator", taskType, dataType));
        if (field != null && record != null) {
            return String.format("ROW FORMAT DELIMITED FIELDS TERMINATED BY '%s' LINES SEPARATED BY '%s' ", field, record);
        }
        if (field != null) {
            return String.format("ROW FORMAT DELIMITED FIELDS TERMINATED BY '%s' ", field);
        }
        if (record != null) {
            return String.format("ROW FORMAT DELIMITED LINES SEPARATED BY '%s' ", record);
        }
        return null;
    }

    public SqlGenContext(JobConf conf, String id) {
        this.job = conf;
        this.id = id;
    }

    public SqlGenContext(JobConf conf, String id, Pipeline pipeline) {
        this.job = conf;
        this.id = id;
        this.pipeline = pipeline;
        if (this.pipeline != null) {
            this.pipeMode = true;
        }
    }
}

