/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.sqlgen;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.mapred.bridge.MetaExplorer;
import com.aliyun.odps.mapred.bridge.sqlgen.SqlGenContext;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class SqlGenerator {
    public static String generate(JobConf job, String id, MetaExplorer metaExplorer, Map<String, String> aliasToTempResource) {
        if (!SqlGenerator.isSqlMode(job, metaExplorer)) {
            return null;
        }
        SqlGenerator.createFunction((BridgeJobConf)job, id, aliasToTempResource);
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)p);
        VelocityContext context = new VelocityContext();
        Template template = null;
        try {
            String vm = "sql";
            Pipeline pipeline = null;
            if (job.isStreamJob()) {
                vm = "stream";
            } else if (job.isPipeline()) {
                pipeline = Pipeline.fromJobConf((JobConf)job);
                assert (pipeline != null);
                context.put("pipes", (Object)pipeline.getNodes());
                vm = "pl";
            }
            context.put("ctx", (Object)new SqlGenContext(job, id, pipeline));
            if (!job.getBoolean("odps.optimizer.cbo.remove.shuffle", false)) {
                job.setBoolean("odps.optimizer.cbo.remove.shuffle", false);
            }
            if (!job.getBoolean("odps.optimizer.cbo.enable.dynamic.parallelism", false)) {
                job.setBoolean("odps.optimizer.cbo.enable.dynamic.parallelism", false);
            }
            template = Velocity.getTemplate((String)String.format("%s.vm", vm));
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ParseErrorException e) {
            throw new RuntimeException(e);
        }
        catch (MethodInvocationException e) {
            throw new RuntimeException(e);
        }
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        return sw.toString();
    }

    static void createFunction(BridgeJobConf job, String jobId, Map<String, String> aliasToTempResource) {
        StringBuilder resouceText = new StringBuilder();
        StringBuilder createText = new StringBuilder();
        for (String s : job.getFunctionResources()) {
            resouceText.append(s).append(",");
        }
        if (job.isStreamJob()) {
            resouceText.deleteCharAt(resouceText.lastIndexOf(","));
            createText.append(String.format("set %s=", "odps.sql.session.resources"));
            if (job.get("odps.sql.session.resources") != null) {
                createText.append(String.format("%s,", job.get("odps.sql.session.resources")));
            }
            createText.append(String.format("%s;\n", resouceText.toString()));
            job.setFunctionCreateText(createText.toString());
            return;
        }
        for (String s : job.getResources()) {
            if (aliasToTempResource.keySet().contains(s)) continue;
            resouceText.append(s).append(",");
        }
        resouceText.deleteCharAt(resouceText.lastIndexOf(","));
        if (job.isPipeline()) {
            int index = 0;
            Pipeline pipeline = Pipeline.fromJobConf((JobConf)job);
            for (Pipeline.TransformNode node : pipeline.getNodes()) {
                if ("map".equals(node.getType())) {
                    createText.append(String.format("create temporary function mr2sql_mapper_%s_%d  as 'com.aliyun.odps.mapred.bridge.LotMapperUDTF' using '%s';\n", jobId, index, resouceText.toString()));
                } else {
                    createText.append(String.format("create temporary function mr2sql_reducer_%s_%d  as 'com.aliyun.odps.mapred.bridge.LotReducerUDTF' using '%s';\n", jobId, index, resouceText.toString()));
                }
                ++index;
            }
        } else {
            createText.append(String.format("create temporary function mr2sql_mapper_%s as 'com.aliyun.odps.mapred.bridge.LotMapperUDTF' using '%s';\n", jobId, resouceText.toString()));
            if (job.getNumReduceTasks() > 0) {
                createText.append(String.format("create temporary function mr2sql_reducer_%s as 'com.aliyun.odps.mapred.bridge.LotReducerUDTF' using '%s';\n", jobId, resouceText.toString()));
            }
        }
        job.setFunctionCreateText(createText.toString());
        for (String type : Arrays.asList("input", "output")) {
            VolumeInfo[] volumeInfos = type.equals("input") ? InputUtils.getVolumes((JobConf)job) : OutputUtils.getVolumes((JobConf)job);
            if (volumeInfos == null || volumeInfos.length <= 0) continue;
            StringBuilder vols = new StringBuilder();
            for (VolumeInfo vol : volumeInfos) {
                vols.append(vol.toString());
                if (vol.getLabel() != null) {
                    vols.append(':').append(vol.getLabel());
                }
                vols.append(",");
            }
            vols.deleteCharAt(vols.lastIndexOf(","));
            job.set(String.format("odps.sql.volume.%s", type), vols.toString());
        }
    }

    static boolean isSqlMode(JobConf job, MetaExplorer metaExplorer) {
        if (System.getProperty("odps.mr.run.mode", "lot").equalsIgnoreCase("sql")) {
            return true;
        }
        String mode = job.get("odps.mr.run.mode");
        if (mode != null) {
            return !mode.equalsIgnoreCase("lot");
        }
        try {
            mode = metaExplorer.getProjectProperty("odps.mr.run.mode");
            if (mode != null && (mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("hybrid"))) {
                return true;
            }
        }
        catch (OdpsException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

