/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordComparator;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.Partitioner;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.GroupingRecordIterator;
import com.aliyun.odps.mapred.bridge.LotTaskUDTF;
import com.aliyun.odps.mapred.bridge.NonGroupingRecordIterator;
import com.aliyun.odps.mapred.bridge.StateInfo;
import com.aliyun.odps.mapred.bridge.UDTFTaskContextImpl;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.bridge.type.ColumnBasedRecordComparator;
import com.aliyun.odps.mapred.bridge.utils.MapReduceUtils;
import com.aliyun.odps.mapred.bridge.utils.VersionUtils;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.InvalidInvocationException;
import com.aliyun.odps.udf.UDFException;
import com.aliyun.odps.udf.annotation.NotReuseArgumentObject;
import com.aliyun.odps.udf.annotation.PreferWritable;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;

@PreferWritable
@NotReuseArgumentObject
public class LotMapperUDTF
extends LotTaskUDTF {
    private Mapper.TaskContext ctx;
    private long rowNum;
    private long nextCntr = 1L;
    private long nextRecordCntr = 1L;
    private Column[] inputSchema;

    public LotMapperUDTF() {
    }

    public LotMapperUDTF(String functionName) {
        super(functionName);
    }

    public com.aliyun.odps.udf.OdpsType[] resolve(com.aliyun.odps.udf.OdpsType[] sig) {
        boolean hasReduce;
        String funtionName = this.conf.get("odps.mr.sql.functionName");
        if (funtionName == null) {
            try {
                return super.resolve(sig);
            }
            catch (UDFException e) {
                e.printStackTrace();
            }
        }
        OdpsType[] resolved = null;
        UDTFTaskContextImpl ctx = new UDTFTaskContextImpl(this.conf){

            public void write(Record record) throws IOException {
            }

            public void write(Record record, String label) throws IOException {
            }

            public void write(Record key, Record value) throws IOException {
            }
        };
        if (ctx.isPipelineMode()) {
            hasReduce = ctx.getPipeline().getNodeNum() > 1;
        } else {
            int numReduceTasks = this.conf.getInt("odps.stage.reducer.num", -1);
            if (numReduceTasks == -1) {
                numReduceTasks = this.conf.getInt("odps.mapred.reduce.tasks", -1);
            }
            if (numReduceTasks == -1) {
                numReduceTasks = 1;
            }
            boolean bl = hasReduce = numReduceTasks > 0;
        }
        if (hasReduce) {
            resolved = SchemaUtils.getTypes((Column[])ctx.getIntermediateOutputSchema());
            if (ctx.isPipelineMode()) {
                resolved = SchemaUtils.getTypes((Column[])ctx.getPipelineOutputSchema(0));
            }
        } else {
            resolved = SchemaUtils.getTypes((Column[])ctx.getPackagedOutputSchema());
        }
        return VersionUtils.getOdpsTypes(resolved);
    }

    public TypeInfo[] resolve(TypeInfo[] sig) {
        boolean hasReduce;
        String funtionName = this.conf.get("odps.mr.sql.functionName");
        if (funtionName == null) {
            try {
                return super.resolve(sig);
            }
            catch (UDFException e) {
                e.printStackTrace();
            }
        }
        TypeInfo[] resolved = null;
        UDTFTaskContextImpl ctx = new UDTFTaskContextImpl(this.conf){

            public void write(Record record) throws IOException {
            }

            public void write(Record record, String label) throws IOException {
            }

            public void write(Record key, Record value) throws IOException {
            }
        };
        if (ctx.isPipelineMode()) {
            hasReduce = ctx.getPipeline().getNodeNum() > 1;
        } else {
            int numReduceTasks = this.conf.getInt("odps.stage.reducer.num", -1);
            if (numReduceTasks == -1) {
                numReduceTasks = this.conf.getInt("odps.mapred.reduce.tasks", -1);
            }
            if (numReduceTasks == -1) {
                numReduceTasks = 1;
            }
            boolean bl = hasReduce = numReduceTasks > 0;
        }
        if (hasReduce) {
            resolved = SchemaUtils.getTypeInfos((Column[])ctx.getIntermediateOutputSchema());
            if (ctx.isPipelineMode()) {
                resolved = SchemaUtils.getTypeInfos((Column[])ctx.getPipelineOutputSchema(0));
            }
        } else {
            resolved = SchemaUtils.getTypeInfos((Column[])ctx.getPackagedOutputSchema());
        }
        return resolved;
    }

    TableInfo getTableInfoFromDesc(String inputSpec) {
        if (inputSpec == null || inputSpec.isEmpty()) {
            throw new RuntimeException(ErrorCode.INTERNAL_ERROR.toString() + ": Input table spec not found");
        }
        if (inputSpec.indexOf(";") > 0) {
            int sepIdx = inputSpec.indexOf(";");
            int divIdx = inputSpec.indexOf("/");
            divIdx = divIdx < 0 ? Integer.MAX_VALUE : divIdx;
            sepIdx = Math.min(sepIdx, divIdx);
            inputSpec = inputSpec.substring(0, sepIdx);
        }
        TableInfo.TableInfoBuilder builder = TableInfo.builder();
        String[] kv = inputSpec.split("/", 2);
        String tableSpec = kv[0];
        String[] prjtbl = tableSpec.split("\\.", 2);
        builder.projectName(prjtbl[0]).tableName(prjtbl[1]);
        if (kv.length == 2) {
            builder.partSpec(kv[1]);
        }
        return builder.build();
    }

    TableInfo getTableInfo(TableInfo[] inputs, String inputSpec) {
        TableInfo info = this.getTableInfoFromDesc(inputSpec);
        for (TableInfo input : inputs) {
            if (!MapReduceUtils.partSpecInclusive(input, info)) continue;
            TableInfo tmpInfo = new TableInfo(input);
            tmpInfo.setPartSpec(info.getPartSpec());
            info = tmpInfo;
        }
        return info;
    }

    public void setup(ExecutionContext context) {
        TableInfo tableInfo = null;
        TableInfo[] inputs = InputUtils.getTables((JobConf)this.conf);
        if (inputs != null && inputs.length > 0) {
            try {
                String inputSpec = context.getTableInfo();
                tableInfo = this.getTableInfo(inputs, inputSpec);
            }
            catch (InvalidInvocationException e) {
                tableInfo = inputs[0];
            }
            if (inputs.length == 1 && !tableInfo.getTableName().equalsIgnoreCase(inputs[0].getTableName())) {
                tableInfo = inputs[0];
            }
        }
        this.inputSchema = tableInfo != null ? this.conf.getInputSchema(tableInfo) : new Column[0];
        this.ctx = this.conf.getCombinerClass() != null && this.conf.getNumReduceTasks() > 0 ? new ProxiedMapContextImpl(this.conf, tableInfo, context) : new DirectMapContextImpl(this.conf, tableInfo, context);
    }

    public void close() {
        try {
            if (this.ctx instanceof ProxiedMapContextImpl) {
                ((ProxiedMapContextImpl)this.ctx).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void run() throws IOException {
        StateInfo.init();
        MapReduceUtils.runMapper(this.conf.getMapperClass(), this.ctx);
        if (!this.conf.getBoolean("odps.mapred.mark.input.columns.all.used", false) && this.ctx instanceof DirectMapContextImpl) {
            ((DirectMapContextImpl)this.ctx).AddFrameworkCounters();
        }
        StateInfo.updateMemStat("mapper end");
        StateInfo.printMaxMemo();
    }

    public Object[] getNextRowWapper() {
        Object[] data = this.getNextRow();
        if (data != null) {
            return (Object[])data.clone();
        }
        return null;
    }

    class ProxiedMapContextImpl
    extends DirectMapContextImpl
    implements Closeable {
        CombineContext combineCtx;

        public ProxiedMapContextImpl(BridgeJobConf conf, TableInfo tableInfo, ExecutionContext context) {
            JobConf.SortOrder[] keySortOrder;
            Object[] keyGrpColumns;
            Object[] keySortColumns;
            Column[] keyRS;
            super(conf, tableInfo, context);
            int bufferSize = conf.getCombinerCacheItems();
            float combineBufferSpillPercent = conf.getCombinerCacheSpillPercent();
            Class<? extends RecordComparator> keyComparatorClass = null;
            Class<? extends RecordComparator> keyGroupingComparatorClass = null;
            if (this.pipeMode) {
                keyRS = this.pipeNode.getOutputKeySchema();
                keySortColumns = this.pipeNode.getOutputKeySortColumns();
                keyGrpColumns = this.pipeNode.getOutputGroupingColumns();
                keySortOrder = this.pipeNode.getOutputKeySortOrder();
                keyComparatorClass = conf.getPipelineOutputKeyComparatorClass(this.pipeIndex);
                keyGroupingComparatorClass = conf.getPipelineOutputKeyGroupingComparatorClass(this.pipeIndex);
            } else {
                keyRS = conf.getMapOutputKeySchema();
                keySortColumns = conf.getOutputKeySortColumns();
                keyGrpColumns = conf.getOutputGroupingColumns();
                keySortOrder = conf.getOutputKeySortOrder();
                keyComparatorClass = conf.getOutputKeyComparatorClass();
                keyGroupingComparatorClass = conf.getOutputKeyGroupingComparatorClass();
            }
            Comparator keyComparator = keyComparatorClass != null ? (Comparator)ReflectionUtils.newInstance(keyComparatorClass, (Configuration)this.getJobConf()) : new ColumnBasedRecordComparator((String[])keySortColumns, keyRS, keySortOrder);
            this.combineCtx = conf.getCombinerOptimizeEnable() && Arrays.deepEquals(keySortColumns, keyGrpColumns) && keyComparatorClass == keyGroupingComparatorClass ? new NonGroupingCombineContextImpl(conf, bufferSize, combineBufferSpillPercent, keyComparator, context) : new GroupingCombineContextImpl(conf, bufferSize, keyComparator, context);
        }

        @Override
        public void write(Record key, Record value) {
            try {
                this.combineCtx.offerKeyValue(key, value);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void writeDirect(Record key, Record value) {
            super.write(key, value);
        }

        @Override
        public void close() throws IOException {
            this.combineCtx.spill();
        }

        class GroupingCombineContextImpl
        extends DirectMapContextImpl
        implements Reducer.TaskContext,
        CombineContext {
            private int velocity;
            private Record key;
            private Record value;
            private GroupingRecordIterator itr;
            private CombinerBuffer combinerBuffer;
            private Comparator<Object[]> keyComparator;
            private Comparator<Object[]> keyGroupingComparator;

            public GroupingCombineContextImpl(BridgeJobConf conf, int bufferSize, Comparator<Object[]> comparator, ExecutionContext context) {
                super(conf, null, context);
                this.velocity = 0;
                this.keyComparator = null;
                this.keyGroupingComparator = null;
                this.configure(context, comparator);
                this.velocity = bufferSize;
                this.combinerBuffer = new CombinerBuffer(bufferSize, this.keyComparator);
            }

            public void configure(ExecutionContext ctx, Comparator<Object[]> comparator) {
                JobConf.SortOrder[] keySortOrder;
                Column[] keyRS;
                String[] keyGrpColumns;
                super.configure(ctx);
                this.keyComparator = comparator;
                Class<? extends RecordComparator> keyComparatorClass = null;
                Class<? extends RecordComparator> keyGroupingComparatorClass = null;
                if (this.pipeMode) {
                    this.key = new WritableRecord(this.pipeNode.getOutputKeySchema());
                    this.value = new WritableRecord(this.pipeNode.getOutputValueSchema());
                    keyGrpColumns = this.pipeNode.getOutputGroupingColumns();
                    keyRS = this.pipeNode.getOutputKeySchema();
                    keySortOrder = this.pipeNode.getOutputKeySortOrder();
                    keyComparatorClass = this.pipeNode.getInputKeyComparatorClass();
                    keyGroupingComparatorClass = this.pipeNode.getInputKeyGroupingComparatorClass();
                } else {
                    this.key = new WritableRecord(this.conf.getMapOutputKeySchema());
                    this.value = new WritableRecord(this.conf.getMapOutputValueSchema());
                    keyGrpColumns = this.conf.getOutputGroupingColumns();
                    keyRS = this.conf.getMapOutputKeySchema();
                    keySortOrder = this.conf.getOutputKeySortOrder();
                    keyComparatorClass = this.conf.getOutputKeyComparatorClass();
                    keyGroupingComparatorClass = this.conf.getOutputKeyGroupingComparatorClass();
                }
                this.keyGroupingComparator = keyGroupingComparatorClass != null ? (Comparator<Object>)ReflectionUtils.newInstance(keyGroupingComparatorClass, (Configuration)this.getJobConf()) : (keyComparatorClass != null ? this.keyComparator : new ColumnBasedRecordComparator(keyGrpColumns, keyRS, keySortOrder));
            }

            @Override
            public void write(Record r) throws IOException {
                ProxiedMapContextImpl.this.write(r);
            }

            @Override
            public void write(Record r, String label) throws IOException {
                ProxiedMapContextImpl.this.write(r, label);
            }

            public Record getCurrentKey() {
                return this.key;
            }

            public boolean nextKeyValue() {
                if (this.itr == null) {
                    Object[] init = (Object[])this.combinerBuffer.peek();
                    if (init == null) {
                        return false;
                    }
                    this.itr = new GroupingRecordIterator(this.combinerBuffer, (WritableRecord)this.key, (WritableRecord)this.value, this.keyGroupingComparator);
                    this.key.set(Arrays.copyOf(init, this.key.getColumnCount()));
                } else {
                    while (this.itr.hasNext()) {
                        this.itr.remove();
                    }
                    if (!this.itr.reset()) {
                        return false;
                    }
                }
                return true;
            }

            public Iterator<Record> getValues() {
                return this.itr;
            }

            @Override
            public void write(Record key, Record value) {
                ProxiedMapContextImpl.this.writeDirect(key, value);
            }

            @Override
            public void spill() {
                this.combine();
            }

            @Override
            public void offerKeyValue(Record key, Record value) throws InterruptedException {
                this.combinerBuffer.offerKeyValue(key, value);
                if (this.combinerBuffer.size() >= this.velocity) {
                    this.combine();
                }
            }

            private void combine() {
                this.itr = null;
                try {
                    MapReduceUtils.runReducer(this.getCombinerClass(), this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private class CombinerBuffer
            extends PriorityQueue<Object[]> {
                private static final long serialVersionUID = 1L;

                public CombinerBuffer(int velocity, Comparator<Object[]> comparator) {
                    super(velocity, comparator);
                }

                public boolean offerKeyValue(Record key, Record value) throws InterruptedException {
                    return super.offer(ArrayUtils.addAll((Object[])((WritableRecord)key).toWritableArray(), (Object[])((WritableRecord)value).toWritableArray()));
                }
            }
        }

        class NonGroupingCombineContextImpl
        extends DirectMapContextImpl
        implements Reducer.TaskContext,
        CombineContext {
            private Record key;
            private Record value;
            private Iterator<Map.Entry<Object[], List<Object[]>>> itr;
            private List<Object[]> curValuelist;
            private int velocity;
            private int threshold;
            private int size;
            private CombinerBuffer combinerBuffer;
            private CombinerBuffer backupCombinerBuffer;
            private NonGroupingRecordIterator recordsItr;

            public NonGroupingCombineContextImpl(BridgeJobConf conf, int velocity, float spillPercent, Comparator<Object[]> keyComparator, ExecutionContext context) {
                super(conf, null, context);
                this.velocity = 0;
                this.threshold = 0;
                this.size = 0;
                if (this.pipeMode) {
                    this.key = new WritableRecord(this.pipeNode.getOutputKeySchema());
                    this.value = new WritableRecord(this.pipeNode.getOutputValueSchema());
                } else {
                    this.key = new WritableRecord(conf.getMapOutputKeySchema());
                    this.value = new WritableRecord(conf.getMapOutputValueSchema());
                }
                this.velocity = velocity;
                this.threshold = (int)((float)velocity * spillPercent);
                if (this.threshold < 0) {
                    this.threshold = 0;
                } else if (this.threshold > velocity) {
                    this.threshold = velocity;
                }
                this.combinerBuffer = new CombinerBuffer(keyComparator);
                this.backupCombinerBuffer = new CombinerBuffer(keyComparator);
            }

            @Override
            public void write(Record r) throws IOException {
                ProxiedMapContextImpl.this.write(r);
            }

            @Override
            public void write(Record r, String label) throws IOException {
                ProxiedMapContextImpl.this.write(r, label);
            }

            public Record getCurrentKey() {
                return this.key;
            }

            public boolean nextKeyValue() {
                if (this.itr.hasNext()) {
                    Map.Entry<Object[], List<Object[]>> entry = this.itr.next();
                    this.curValuelist = entry.getValue();
                    this.recordsItr = new NonGroupingRecordIterator(this.curValuelist, (WritableRecord)this.value);
                    this.key.set(Arrays.copyOf(entry.getKey(), this.key.getColumnCount()));
                    return true;
                }
                return false;
            }

            public Iterator<Record> getValues() {
                return this.recordsItr;
            }

            @Override
            public void write(Record key, Record value) {
                try {
                    this.backupCombinerBuffer.offerKeyValue(key, value);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void offerKeyValue(Record key, Record value) throws InterruptedException {
                this.combinerBuffer.offerKeyValue(key, value);
                if (++this.size >= this.velocity) {
                    this.combine();
                    if (this.backupCombinerBuffer.size() >= this.threshold) {
                        this.spill();
                    } else {
                        CombinerBuffer tmp = null;
                        tmp = this.combinerBuffer;
                        this.combinerBuffer = this.backupCombinerBuffer;
                        this.backupCombinerBuffer = tmp;
                        this.size = this.combinerBuffer.size();
                    }
                }
            }

            @Override
            public void spill() {
                if (this.combinerBuffer.size() > 0) {
                    this.combine();
                }
                for (Map.Entry it : this.backupCombinerBuffer.entrySet()) {
                    List objList = (List)it.getValue();
                    ((WritableRecord)this.key).set((Object[])it.getKey());
                    ((WritableRecord)this.value).set((Object[])objList.get(0));
                    ProxiedMapContextImpl.this.writeDirect(this.key, this.value);
                }
                this.backupCombinerBuffer.clear();
            }

            private void combine() {
                this.itr = this.combinerBuffer.entrySet().iterator();
                try {
                    MapReduceUtils.runReducer(this.getCombinerClass(), this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.combinerBuffer.clear();
                    this.size = 0;
                }
            }

            private class CombinerBuffer
            extends TreeMap<Object[], List<Object[]>> {
                private static final long serialVersionUID = 1L;

                public CombinerBuffer(Comparator<Object[]> comparator) {
                    super(comparator);
                }

                public boolean offerKeyValue(Record key, Record value) throws InterruptedException {
                    List<Writable[]> objValue;
                    boolean rt = false;
                    Writable[] objKey = Arrays.copyOf(((WritableRecord)key).toWritableArray(), key.getColumnCount());
                    if (super.containsKey(objKey)) {
                        objValue = (List)super.get(objKey);
                    } else {
                        objValue = new ArrayList();
                        super.put(objKey, objValue);
                    }
                    rt = objValue.add(Arrays.copyOf(((WritableRecord)value).toWritableArray(), value.getColumnCount()));
                    return rt;
                }
            }
        }
    }

    static interface CombineContext {
        public void offerKeyValue(Record var1, Record var2) throws InterruptedException;

        public void spill();
    }

    class DirectMapContextImpl
    extends UDTFTaskContextImpl
    implements Mapper.TaskContext {
        Record record;
        TableInfo inputTableInfo;
        Partitioner partitioner;

        public DirectMapContextImpl(BridgeJobConf conf, TableInfo tableInfo, ExecutionContext context) {
            super(conf);
            this.inputTableInfo = tableInfo;
            this.record = new WritableRecord(LotMapperUDTF.this.inputSchema);
            if (!conf.getBoolean("odps.mapred.mark.input.columns.all.used", false)) {
                ((WritableRecord)this.record).setEnableColumnAccessStat(true);
            }
            this.configure(context);
        }

        @Override
        boolean isMapper() {
            return true;
        }

        @Override
        public void configure(ExecutionContext ctx) {
            Class partitionerClass;
            super.configure(ctx);
            if (this.pipeMode) {
                this.conf.setMapperClass(this.pipeNode.getTransformClass());
                partitionerClass = this.pipeNode.getPartitionerClass();
            } else {
                partitionerClass = this.getJobConf().getPartitionerClass();
            }
            if (this.inputTableInfo != null && this.inputTableInfo.getMapperClass() != null) {
                this.conf.setMapperClass(this.inputTableInfo.getMapperClass());
            }
            if (partitionerClass != null) {
                this.partitioner = (Partitioner)ReflectionUtils.newInstance((Class)partitionerClass, (Configuration)this.getJobConf());
                this.partitioner.configure((JobConf)this.conf);
            }
            if (this.innerOutput && this.reducerNum > 0) {
                Column[] keyCols = new Column[]{};
                Column[] valCols = new Column[]{};
                if (this.pipeMode && this.pipeNode != null && this.pipeNode.getType().equals("map")) {
                    keyCols = this.pipeNode.getOutputKeySchema();
                    valCols = this.pipeNode.getOutputValueSchema();
                } else {
                    keyCols = this.conf.getMapOutputKeySchema();
                    valCols = this.conf.getMapOutputValueSchema();
                }
                Column[] outputFields = new Column[keyCols.length + valCols.length + this.packagedOutputSchema.length];
                int len = 0;
                for (Column col : keyCols) {
                    outputFields[len++] = col;
                }
                for (Column col : valCols) {
                    outputFields[len++] = col;
                }
                this.innerOutputIndex = len;
                for (Column col : this.packagedOutputSchema) {
                    outputFields[len++] = col;
                }
                this.packagedOutputSchema = outputFields;
            }
        }

        public void write(Record r) throws IOException {
            this.write(r, "__default__");
        }

        public void write(Record r, String label) throws IOException {
            if (!this.innerOutput && this.getNumReduceTasks() > 0) {
                throw new UnsupportedOperationException(ErrorCode.UNEXPECTED_MAP_WRITE_OUTPUT.toString());
            }
            if (!this.hasLabel(label)) {
                throw new IOException(ErrorCode.NO_SUCH_LABEL.toString() + " " + label);
            }
            if (this.innerOutput) {
                this.write(this.createInnerOutputRow(((WritableRecord)r).toWritableArray(), true, "INNER_OUTPUT", label));
            } else {
                this.write(this.createOutputRow(r, label));
            }
        }

        public void write(Record key, Record value) {
            Object[] result;
            if (this.getNumReduceTasks() == 0) {
                throw new UnsupportedOperationException(ErrorCode.UNEXPECTED_MAP_WRITE_INTER.toString());
            }
            Writable[] keyArray = ((WritableRecord)key).toWritableArray();
            Writable[] valueArray = ((WritableRecord)value).toWritableArray();
            int idx = 0;
            if (this.partitioner != null) {
                int part = this.partitioner.getPartition(key, value, this.getNumReduceTasks());
                if (part < 0 || part >= this.getNumReduceTasks()) {
                    throw new RuntimeException("partitioner return invalid partition value:" + part);
                }
                result = new Writable[1 + keyArray.length + valueArray.length];
                result[idx++] = new LongWritable((long)part);
            } else {
                result = new Writable[keyArray.length + valueArray.length];
            }
            for (Writable obj : keyArray) {
                result[idx++] = obj;
            }
            for (Writable obj : valueArray) {
                result[idx++] = obj;
            }
            if (this.innerOutput) {
                this.write(this.createInnerOutputRow((Writable[])result, false, "__default__", "__default__"));
            } else {
                this.write(result);
            }
        }

        protected void write(Object[] record) {
            LotMapperUDTF.this.collect(record);
        }

        public long getCurrentRecordNum() {
            return LotMapperUDTF.this.rowNum;
        }

        public Record getCurrentRecord() {
            return this.record;
        }

        public boolean nextRecord() {
            Object[] values = LotMapperUDTF.this.getNextRowWapper();
            if (values == null) {
                return false;
            }
            LotMapperUDTF.this.rowNum++;
            if (LotMapperUDTF.this.rowNum == LotMapperUDTF.this.nextCntr) {
                StateInfo.updateMemStat();
                LotMapperUDTF.this.nextCntr = this.getNextCntr(LotMapperUDTF.this.rowNum, true);
            }
            if (LotMapperUDTF.this.rowNum == LotMapperUDTF.this.nextRecordCntr) {
                StateInfo.updateMemStat("processed " + LotMapperUDTF.this.rowNum + " records");
                LotMapperUDTF.this.nextRecordCntr = this.getNextCntr(LotMapperUDTF.this.rowNum, false);
            }
            this.record.set(values);
            return true;
        }

        public TableInfo getInputTableInfo() {
            return this.inputTableInfo;
        }

        void AddFrameworkCounters() {
            try {
                this.ctx.getCounter("ODPS_SDK_FRAMEWORK_COUNTER_GROUP", "input_col_total_num").setValue((long)this.record.getColumnCount());
                this.ctx.getCounter("ODPS_SDK_FRAMEWORK_COUNTER_GROUP", "input_col_used_num").setValue((long)((WritableRecord)this.record).getColumnAccessedNum());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

