/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordComparator;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.mapred.Partitioner;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.LotGroupingRecordIterator;
import com.aliyun.odps.mapred.bridge.LotTaskUDTF;
import com.aliyun.odps.mapred.bridge.StateInfo;
import com.aliyun.odps.mapred.bridge.UDTFTaskContextImpl;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.bridge.type.ColumnBasedRecordComparator;
import com.aliyun.odps.mapred.bridge.utils.MapReduceUtils;
import com.aliyun.odps.mapred.bridge.utils.VersionUtils;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.pipeline.Pipeline;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.UDFException;
import com.aliyun.odps.udf.annotation.NotReuseArgumentObject;
import com.aliyun.odps.udf.annotation.PreferWritable;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.lang.ArrayUtils;

@PreferWritable
@NotReuseArgumentObject
public class LotReducerUDTF
extends LotTaskUDTF {
    private Reducer.TaskContext ctx;

    public LotReducerUDTF() {
    }

    public LotReducerUDTF(String functionName) {
        super(functionName);
    }

    public com.aliyun.odps.udf.OdpsType[] resolve(com.aliyun.odps.udf.OdpsType[] unused) {
        String funtionName = this.conf.get("odps.mr.sql.functionName");
        if (funtionName == null) {
            try {
                return super.resolve(unused);
            }
            catch (UDFException e) {
                e.printStackTrace();
            }
        }
        this.ctx = new ReduceContextImpl(this.conf);
        Object[] ks = this.conf.getMapOutputKeySchema();
        Object[] vs = this.conf.getMapOutputValueSchema();
        this.inputSchema = (Column[])ArrayUtils.addAll((Object[])ks, (Object[])vs);
        UDTFTaskContextImpl udtfCtx = (UDTFTaskContextImpl)this.ctx;
        if (((UDTFTaskContextImpl)this.ctx).pipeMode) {
            Pipeline pipeline = Pipeline.fromJobConf((JobConf)this.conf);
            int nodeId = Integer.parseInt(funtionName.split("_")[3]);
            Pipeline.TransformNode pipeNode = pipeline.getNode(nodeId);
            Object[] intermediateFields = (Column[])ArrayUtils.addAll((Object[])pipeNode.getOutputKeySchema(), (Object[])pipeNode.getOutputValueSchema());
            if (pipeNode.getPartitionerClass() != null) {
                intermediateFields = (Column[])ArrayUtils.addAll((Object[])SchemaUtils.fromString((String)"__partition_id__:BIGINT"), (Object[])intermediateFields);
            }
            if (intermediateFields != null) {
                OdpsType[] resolved = SchemaUtils.getTypes((Column[])intermediateFields);
                return VersionUtils.getOdpsTypes(resolved);
            }
        }
        return VersionUtils.getOdpsTypes(SchemaUtils.getTypes((Column[])udtfCtx.getPackagedOutputSchema()));
    }

    public TypeInfo[] resolve(TypeInfo[] unused) {
        String funtionName = this.conf.get("odps.mr.sql.functionName");
        if (funtionName == null) {
            try {
                return super.resolve(unused);
            }
            catch (UDFException e) {
                e.printStackTrace();
            }
        }
        this.ctx = new ReduceContextImpl(this.conf);
        Object[] ks = this.conf.getMapOutputKeySchema();
        Object[] vs = this.conf.getMapOutputValueSchema();
        this.inputSchema = (Column[])ArrayUtils.addAll((Object[])ks, (Object[])vs);
        UDTFTaskContextImpl udtfCtx = (UDTFTaskContextImpl)this.ctx;
        if (((UDTFTaskContextImpl)this.ctx).pipeMode) {
            Pipeline pipeline = Pipeline.fromJobConf((JobConf)this.conf);
            int nodeId = Integer.parseInt(funtionName.split("_")[3]);
            Pipeline.TransformNode pipeNode = pipeline.getNode(nodeId);
            Object[] intermediateFields = (Column[])ArrayUtils.addAll((Object[])pipeNode.getOutputKeySchema(), (Object[])pipeNode.getOutputValueSchema());
            if (pipeNode.getPartitionerClass() != null) {
                intermediateFields = (Column[])ArrayUtils.addAll((Object[])SchemaUtils.fromString((String)"__partition_id__:BIGINT"), (Object[])intermediateFields);
            }
            if (intermediateFields != null) {
                TypeInfo[] resolved = SchemaUtils.getTypeInfos((Column[])intermediateFields);
                return resolved;
            }
        }
        return SchemaUtils.getTypeInfos((Column[])udtfCtx.getPackagedOutputSchema());
    }

    public void setup(ExecutionContext eCtx) {
        this.ctx = new ReduceContextImpl(this.conf);
        Object[] ks = this.conf.getMapOutputKeySchema();
        Object[] vs = this.conf.getMapOutputValueSchema();
        this.inputSchema = (Column[])ArrayUtils.addAll((Object[])ks, (Object[])vs);
        UDTFTaskContextImpl udtfCtx = (UDTFTaskContextImpl)this.ctx;
        udtfCtx.configure(eCtx);
    }

    public void run() throws IOException {
        StateInfo.init();
        MapReduceUtils.runReducer(this.conf.getReducerClass(), this.ctx);
        StateInfo.updateMemStat("reducer end");
        StateInfo.printMaxMemo();
    }

    public Object[] getNextRowWapper() {
        Object[] data = this.getNextRow();
        if (data != null) {
            return (Object[])data.clone();
        }
        return null;
    }

    class ReduceContextImpl
    extends UDTFTaskContextImpl
    implements Reducer.TaskContext {
        private Record key;
        private Record value;
        private Comparator<Object[]> keyGroupingComparator;
        private LotGroupingRecordIterator itr;
        Partitioner partitioner;
        private long nextRecordCntr;
        private long inputValueCounter;
        private long inputKeyCounter;

        public ReduceContextImpl(BridgeJobConf conf) {
            super(conf);
            this.nextRecordCntr = 1L;
        }

        @Override
        public void configure(ExecutionContext ctx) {
            Column[] keyRS;
            String[] keyGrpColumns;
            super.configure(ctx);
            Class<? extends RecordComparator> keyComparatorClass = null;
            Class<? extends RecordComparator> keyGroupingComparatorClass = null;
            if (this.pipeMode) {
                this.conf.setReducerClass(this.pipeNode.getTransformClass());
                this.key = new WritableRecord(this.pipeNode.getInputKeySchema());
                this.value = new WritableRecord(this.pipeNode.getInputValueSchema());
                keyGrpColumns = this.pipeNode.getInputGroupingColumns();
                keyRS = this.pipeNode.getInputKeySchema();
                keyComparatorClass = this.conf.getPipelineOutputKeyComparatorClass(this.pipeIndex - 1);
                keyGroupingComparatorClass = this.conf.getPipelineOutputKeyGroupingComparatorClass(this.pipeIndex - 1);
                Class partitionerClass = this.pipeNode.getPartitionerClass();
                if (partitionerClass != null) {
                    this.partitioner = (Partitioner)ReflectionUtils.newInstance((Class)partitionerClass, (Configuration)this.getJobConf());
                    this.partitioner.configure((JobConf)this.conf);
                }
            } else {
                this.key = new WritableRecord(this.conf.getMapOutputKeySchema());
                this.value = new WritableRecord(this.conf.getMapOutputValueSchema());
                keyGrpColumns = this.conf.getOutputGroupingColumns();
                keyRS = this.conf.getMapOutputKeySchema();
                keyComparatorClass = this.conf.getOutputKeyComparatorClass();
                keyGroupingComparatorClass = this.conf.getOutputKeyGroupingComparatorClass();
            }
            this.keyGroupingComparator = keyGroupingComparatorClass != null ? (Comparator)ReflectionUtils.newInstance(keyGroupingComparatorClass, (Configuration)this.getJobConf()) : (keyComparatorClass != null ? (Comparator)ReflectionUtils.newInstance(keyComparatorClass, (Configuration)this.getJobConf()) : new ColumnBasedRecordComparator(keyGrpColumns, keyRS));
            if (this.innerOutput && this.pipeMode && this.pipeNode != null && this.pipeNode.getNextNode() != null) {
                Column[] keyCols = this.pipeNode.getOutputKeySchema();
                Column[] valCols = this.pipeNode.getOutputValueSchema();
                Column[] outputFields = new Column[keyCols.length + valCols.length + this.packagedOutputSchema.length];
                int len = 0;
                for (Column col : keyCols) {
                    outputFields[len++] = col;
                }
                for (Column col : valCols) {
                    outputFields[len++] = col;
                }
                this.innerOutputIndex = len;
                for (Column col : this.packagedOutputSchema) {
                    outputFields[len++] = col;
                }
                this.packagedOutputSchema = outputFields;
            }
        }

        public void write(Record r) throws IOException {
            this.write(r, "__default__");
        }

        public void write(Record r, String label) throws IOException {
            if (!this.hasLabel(label)) {
                throw new IOException(ErrorCode.NO_SUCH_LABEL.toString() + " " + label);
            }
            if (this.innerOutput) {
                this.write(this.createInnerOutputRow(((WritableRecord)r).toWritableArray(), true, "INNER_OUTPUT", label));
            } else {
                this.write(this.createOutputRow(r, label));
            }
        }

        protected void write(Object[] record) {
            LotReducerUDTF.this.collect(record);
        }

        public boolean nextKeyValue() {
            ++this.inputKeyCounter;
            if (this.itr == null) {
                Object[] init = this.getData();
                if (init == null) {
                    return false;
                }
                this.key.set(Arrays.copyOf(init, this.key.getColumnCount()));
                this.value.set(Arrays.copyOfRange(init, this.key.getColumnCount(), init.length));
                this.itr = new LotGroupingRecordIterator(this, this.keyGroupingComparator, init, (WritableRecord)this.key, (WritableRecord)this.value);
            } else {
                while (this.itr.hasNext()) {
                    this.itr.remove();
                }
                if (!this.itr.reset()) {
                    return false;
                }
            }
            return true;
        }

        public Record getCurrentKey() {
            return this.key;
        }

        public Iterator<Record> getValues() {
            return this.itr;
        }

        public void write(Record key, Record value) {
            Object[] result;
            if (!this.pipeMode || this.pipeNode.getNextNode() == null) {
                throw new UnsupportedOperationException(ErrorCode.INTERMEDIATE_OUTPUT_IN_REDUCER.toString());
            }
            Writable[] keyArray = ((WritableRecord)key).toWritableArray();
            Writable[] valueArray = ((WritableRecord)value).toWritableArray();
            int idx = 0;
            if (this.partitioner != null) {
                int part = this.partitioner.getPartition(key, value, this.getNumReduceTasks());
                if (part < 0 || part >= this.getNumReduceTasks()) {
                    throw new RuntimeException("partitioner return invalid partition value:" + part);
                }
                result = new Writable[1 + keyArray.length + valueArray.length];
                result[idx++] = new LongWritable((long)part);
            } else {
                result = new Writable[keyArray.length + valueArray.length];
            }
            for (Writable obj : keyArray) {
                result[idx++] = obj;
            }
            for (Writable obj : valueArray) {
                result[idx++] = obj;
            }
            if (this.innerOutput) {
                this.write(this.createInnerOutputRow((Writable[])result, false, "__default__", "__default__"));
            } else {
                this.write(result);
            }
        }

        public Object[] getData() {
            ++this.inputValueCounter;
            if (this.inputValueCounter == this.nextRecordCntr) {
                StateInfo.updateMemStat("after processed " + this.inputKeyCounter + " keys, " + this.inputValueCounter + " values");
                this.nextRecordCntr = this.getNextCntr(this.inputValueCounter, false);
            }
            return LotReducerUDTF.this.getNextRowWapper();
        }
    }
}

