/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.cli;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.account.StsAccount;
import com.aliyun.odps.mapred.cli.OdpsConf;
import com.aliyun.odps.mapred.conf.SessionState;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class OptionParser {
    private static Options options = new Options();
    private Class<?> mainClass;
    private String[] arguments;
    private SessionState ss;

    public OptionParser(SessionState ss) {
        this.ss = ss;
    }

    public void parse(String[] args) throws ParseException, FileNotFoundException, ClassNotFoundException, OdpsException {
        String[] remain;
        String[] odpsconf;
        BasicParser parser = new BasicParser();
        if (args == null || args.length <= 0) {
            throw new UnsupportedOperationException("Main class not specified.");
        }
        CommandLine cmd = parser.parse(options, args, true);
        OdpsConf odpsConf = new OdpsConf();
        if (cmd.hasOption("odps")) {
            odpsconf = cmd.getOptionValue("odps");
            String[] conf = new File((String)odpsconf);
            FileInputStream in = new FileInputStream((File)conf);
            odpsConf.addResource(in);
        }
        if (cmd.hasOption("odpsconf")) {
            for (String conf : odpsconf = cmd.getOptionValues("odpsconf")) {
                String[] kv = conf.split("=", 2);
                odpsConf.set(kv[0], kv[1]);
            }
        }
        Account account = this.getAccount(odpsConf);
        Odps odps = new Odps(account);
        odps.setDefaultProject(odpsConf.getProjName());
        if (odpsConf.getEndpoint() != null) {
            odps.setEndpoint(odpsConf.getEndpoint());
        }
        this.ss.setOdps(odps);
        if (cmd.hasOption("job")) {
            String jobconf = cmd.getOptionValue("job");
            File conf = new File(jobconf);
            FileInputStream in = new FileInputStream(conf);
            this.ss.getDefaultJob().addResource((InputStream)in);
        }
        if (cmd.hasOption("jobconf")) {
            String[] jobconfs;
            for (String conf : jobconfs = cmd.getOptionValues("jobconf")) {
                String[] kv = conf.split("=", 2);
                this.ss.getDefaultJob().set(kv[0], kv[1]);
            }
        }
        if (cmd.hasOption("aliases")) {
            Map map;
            String aliases = cmd.getOptionValue("aliases");
            try {
                map = (Map)new GsonBuilder().disableHtmlEscaping().create().fromJson(aliases, new TypeToken<Map<String, String>>(){}.getType());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.ss.setAliases(map);
        }
        if (cmd.hasOption("resources")) {
            String resources = cmd.getOptionValue("resources");
            this.ss.getDefaultJob().setResources(resources);
        }
        if (cmd.hasOption("local")) {
            this.ss.setLocalRun(true);
        }
        if ((remain = cmd.getArgs()) == null || remain.length <= 0) {
            throw new UnsupportedOperationException("Main class not specified.");
        }
        this.mainClass = Class.forName(remain[0]);
        this.arguments = remain.length > 1 ? Arrays.copyOfRange(remain, 1, remain.length) : new String[0];
    }

    public void usage() {
        new HelpFormatter().printHelp("mapreduce [<GENERIC_OPTIONS>] <MAIN_CLASS> [ARGS]", options);
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    private Account getAccount(OdpsConf odpsConf) throws OdpsException {
        Account.AccountProvider accountProvider = odpsConf.getAccountProvider();
        switch (accountProvider) {
            case ALIYUN: {
                return new AliyunAccount(odpsConf.getAccessId(), odpsConf.getAccessKey());
            }
            case STS: {
                return new StsAccount(odpsConf.getAccessId(), odpsConf.getAccessKey(), odpsConf.getStsToken());
            }
        }
        throw new OdpsException("unsupport account provider:" + accountProvider);
    }

    static {
        OptionBuilder.withArgName((String)"resources");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Library resource names, seperated by comma");
        Option resources = OptionBuilder.create((String)"resources");
        options.addOption(resources);
        OptionBuilder.withArgName((String)"jobconf");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Job config parameters, overriding default mapreduce-conf.xml");
        Option jobconf = OptionBuilder.create((String)"jobconf");
        options.addOption(jobconf);
        OptionBuilder.withArgName((String)"odpsconf");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Odps config parameters, overriding default odps-conf.xml");
        Option odpsconf = OptionBuilder.create((String)"odpsconf");
        options.addOption(odpsconf);
        OptionBuilder.withArgName((String)"job");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Job config file path, overriding default mapreduce-conf.xml");
        Option job = OptionBuilder.create((String)"job");
        options.addOption(job);
        OptionBuilder.withArgName((String)"odps");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Odps config file path, overriding default odps-conf.xml");
        Option odps = OptionBuilder.create((String)"odps");
        options.addOption(odps);
        OptionBuilder.withArgName((String)"aliases");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Odps alias settings");
        Option aliases = OptionBuilder.create((String)"aliases");
        options.addOption(aliases);
        OptionBuilder.withArgName((String)"local");
        OptionBuilder.withDescription((String)"Enable local run mode.");
        Option localrun = OptionBuilder.create((String)"local");
        options.addOption(localrun);
    }
}

