/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph;

import com.aliyun.odps.graph.ComputeContext;
import com.aliyun.odps.graph.Edge;
import com.aliyun.odps.graph.WorkerContext;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class Vertex<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable> {
    private I id;
    private V value;
    private boolean halt;
    private List<Edge<I, E>> edges = null;

    public final void setId(I id) {
        this.id = id;
    }

    public final I getId() {
        return this.id;
    }

    public final V getValue() {
        return this.value;
    }

    public final void setValue(V value) {
        this.value = value;
    }

    public void voteToHalt() {
        this.halt = true;
    }

    public void wakeUp() {
        this.halt = false;
    }

    public boolean isHalted() {
        return this.halt;
    }

    public final boolean hasEdges() {
        return this.edges != null && !this.edges.isEmpty();
    }

    public final List<Edge<I, E>> getEdges() {
        return this.edges;
    }

    public final int getNumEdges() {
        return this.hasEdges() ? this.getEdges().size() : 0;
    }

    public final void setEdges(List<Edge<I, E>> edges) {
        this.edges = edges;
    }

    public final void addEdge(I destVertexId, E edgeValue) {
        if (this.edges == null) {
            this.edges = new ArrayList<Edge<I, E>>(1);
        }
        this.edges.add(new Edge<I, E>(destVertexId, edgeValue));
    }

    public final List<Edge<I, E>> removeEdges(I destVertexId) {
        ArrayList<Edge<I, Edge<I, E>>> removeEdges = new ArrayList<Edge<I, Edge<I, E>>>();
        if (this.edges != null) {
            for (Edge<I, E> edge : this.edges) {
                if (!edge.getDestVertexId().equals(destVertexId)) continue;
                removeEdges.add(edge);
            }
            this.edges.removeAll(removeEdges);
        }
        return removeEdges;
    }

    public void setup(WorkerContext<I, V, E, M> context) throws IOException {
    }

    public abstract void compute(ComputeContext<I, V, E, M> var1, Iterable<M> var2) throws IOException;

    public void cleanup(WorkerContext<I, V, E, M> context) throws IOException {
    }

    public String toString() {
        return "Vertex(id=" + this.getId() + ",value=" + this.getValue() + ",#edgesNum=" + this.getNumEdges() + ")";
    }
}

