/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.Lot;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.IllegalOperationException;
import java.util.ArrayList;
import java.util.List;

public abstract class Operator {
    private static int identity = 0;
    private String id;
    private List<Operator> children = new ArrayList<Operator>();
    private List<Operator> parents = new ArrayList<Operator>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Operator() {
        this.id = Integer.toString(Operator.genId());
    }

    public abstract Lot.LogicalOperator toProtoBuf();

    private static synchronized int genId() {
        return identity++;
    }

    public void addChild(Operator child) throws IllegalArgumentException, IllegalOperationException {
        if (child == null) {
            throw new ArgumentNullException("child");
        }
        if (this.children.indexOf(child) == -1) {
            this.children.add(child);
            child.parents.add(this);
            this.onAddChild(child);
            child.onBeAddedAsChild(this);
        }
    }

    protected void onAddChild(Operator child) throws IllegalOperationException {
    }

    protected void onBeAddedAsChild(Operator parent) throws IllegalOperationException {
    }

    public List<Operator> getChildren() {
        return this.children;
    }

    public List<Operator> getParents() {
        return this.parents;
    }
}

