/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.image;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.OutputStreamSet;
import com.aliyun.odps.io.SinkOutputStream;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Outputer;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageOutputer
extends Outputer {
    private OutputStreamSet outputStreamSet;
    private DataAttributes attributes;
    private String outputFormat = "jpg";
    private float[] sobel = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};

    public void setup(ExecutionContext ctx, OutputStreamSet outputStreamSet, DataAttributes attributes) {
        this.outputStreamSet = outputStreamSet;
        this.attributes = attributes;
        this.attributes.verifySchema(new OdpsType[]{OdpsType.STRING, OdpsType.BIGINT, OdpsType.BIGINT, OdpsType.BINARY});
    }

    public void output(Record record) throws IOException {
        String name = record.getString(0);
        Long width = record.getBigint(1);
        Long height = record.getBigint(2);
        ByteArrayInputStream input = new ByteArrayInputStream(record.getBytes(3));
        BufferedImage sobelEdgeImage = this.getEdgeImage(input);
        SinkOutputStream outputStream = this.outputStreamSet.next(name + "_" + width + "x" + height + "." + this.outputFormat);
        ImageIO.write((RenderedImage)sobelEdgeImage, this.outputFormat, (OutputStream)outputStream);
    }

    public void close() throws IOException {
    }

    private BufferedImage getEdgeImage(InputStream input) throws IOException {
        BufferedImage image = ImageIO.read(input);
        ConvolveOp sobelFilter = new ConvolveOp(new Kernel(3, 3, this.sobel));
        return sobelFilter.filter(image, null);
    }
}

