/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol;

import com.aliyun.openservices.shade.com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.CommandCustomHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.annotation.CFNotNull;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommandType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCopyElisionRequestCode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RocketMQSerializable;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.SerializeType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.qos.QoS;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RemotingCommand {
    public static final String SERIALIZE_TYPE_PROPERTY = "rocketmq.serialize.type";
    public static final String SERIALIZE_TYPE_ENV = "ROCKETMQ_SERIALIZE_TYPE";
    public static final String REMOTING_VERSION_KEY = "rocketmq.remoting.version";
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final int RPC_TYPE = 0;
    private static final int RPC_ONEWAY = 1;
    private static final Map<Class<? extends CommandCustomHeader>, Field[]> CLASS_HASH_MAP = new HashMap<Class<? extends CommandCustomHeader>, Field[]>();
    private static final Map<Class, String> CANONICAL_NAME_CACHE = new HashMap<Class, String>();
    private static final Map<Field, Boolean> NULLABLE_FIELD_CACHE = new HashMap<Field, Boolean>();
    private static final String STRING_CANONICAL_NAME = String.class.getCanonicalName();
    private static final String DOUBLE_CANONICAL_NAME_1 = Double.class.getCanonicalName();
    private static final String DOUBLE_CANONICAL_NAME_2 = Double.TYPE.getCanonicalName();
    private static final String INTEGER_CANONICAL_NAME_1 = Integer.class.getCanonicalName();
    private static final String INTEGER_CANONICAL_NAME_2 = Integer.TYPE.getCanonicalName();
    private static final String LONG_CANONICAL_NAME_1 = Long.class.getCanonicalName();
    private static final String LONG_CANONICAL_NAME_2 = Long.TYPE.getCanonicalName();
    private static final String BOOLEAN_CANONICAL_NAME_1 = Boolean.class.getCanonicalName();
    private static final String BOOLEAN_CANONICAL_NAME_2 = Boolean.TYPE.getCanonicalName();
    private static volatile int configVersion = -1;
    private static AtomicInteger requestId = new AtomicInteger(0);
    private static SerializeType serializeTypeConfigInThisServer = SerializeType.JSON;
    private int code;
    private LanguageCode language = LanguageCode.JAVA;
    private int version = 0;
    private int opaque = requestId.getAndIncrement();
    private int flag = 0;
    private String remark;
    private HashMap<String, String> extFields;
    private transient CommandCustomHeader customHeader;
    private SerializeType serializeTypeCurrentRPC = serializeTypeConfigInThisServer;
    private transient ByteBuffer body;
    private transient ReferenceCounted refCnt;
    private transient ByteBuf payload;
    private transient QoS qos;
    private final transient AtomicBoolean copied = new AtomicBoolean(false);
    private String namespaceId;

    protected RemotingCommand() {
        this.qos = QoS.NORMAL;
    }

    public static RemotingCommand createRequestCommand(int code, CommandCustomHeader customHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        cmd.customHeader = customHeader;
        RemotingCommand.setCmdVersion(cmd);
        return cmd;
    }

    private static void setCmdVersion(RemotingCommand cmd) {
        if (configVersion >= 0) {
            cmd.setVersion(configVersion);
        } else {
            String v = System.getProperty(REMOTING_VERSION_KEY);
            if (v != null) {
                int value = Integer.parseInt(v);
                cmd.setVersion(value);
                configVersion = value;
            }
        }
    }

    public static RemotingCommand createResponseCommand(Class<? extends CommandCustomHeader> classHeader) {
        return RemotingCommand.createResponseCommand(1, "not set any response code", classHeader);
    }

    public static RemotingCommand createResponseCommand(int code, String remark, Class<? extends CommandCustomHeader> classHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        cmd.setRemark(remark);
        RemotingCommand.setCmdVersion(cmd);
        if (classHeader != null) {
            try {
                CommandCustomHeader objectHeader;
                cmd.customHeader = objectHeader = classHeader.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, String remark) {
        return RemotingCommand.createResponseCommand(code, remark, null);
    }

    public static RemotingCommand decode(byte[] array) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        return RemotingCommand.decode(byteBuffer);
    }

    public static RemotingCommand decode(ByteBuffer byteBuffer) {
        int length = byteBuffer.limit();
        int oriHeaderLen = byteBuffer.getInt();
        int headerLength = RemotingCommand.getHeaderLength(oriHeaderLen);
        byte[] headerData = new byte[headerLength];
        byteBuffer.get(headerData);
        RemotingCommand cmd = RemotingCommand.headerDecode(headerData, RemotingCommand.getProtocolType(oriHeaderLen));
        int bodyLength = length - 4 - headerLength;
        if (bodyLength > 0 && null != cmd) {
            if (RemotingCopyElisionRequestCode.COPY_ELISION_LIST.contains(cmd.code)) {
                cmd.body = byteBuffer.slice();
            } else {
                cmd.body = ByteBuffer.allocate(bodyLength);
                cmd.body.put(byteBuffer);
                cmd.body.flip();
            }
        }
        return cmd;
    }

    public static int getHeaderLength(int length) {
        return length & 0xFFFFFF;
    }

    private static RemotingCommand headerDecode(byte[] headerData, SerializeType type) {
        switch (type) {
            case JSON: {
                RemotingCommand resultJson = RemotingSerializable.decode(headerData, RemotingCommand.class);
                resultJson.setSerializeTypeCurrentRPC(type);
                return resultJson;
            }
            case ROCKETMQ: {
                RemotingCommand resultRMQ = RocketMQSerializable.rocketMQProtocolDecode(headerData);
                resultRMQ.setSerializeTypeCurrentRPC(type);
                return resultRMQ;
            }
        }
        return null;
    }

    public static SerializeType getProtocolType(int source) {
        return SerializeType.valueOf((byte)(source >> 24 & 0xFF));
    }

    public static int createNewRequestId() {
        return requestId.getAndIncrement();
    }

    public static SerializeType getSerializeTypeConfigInThisServer() {
        return serializeTypeConfigInThisServer;
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte[] markProtocolType(int source, SerializeType type) {
        byte[] result = new byte[]{type.getCode(), (byte)(source >> 16 & 0xFF), (byte)(source >> 8 & 0xFF), (byte)(source & 0xFF)};
        return result;
    }

    public void markResponseType() {
        int bits = 1;
        this.flag |= bits;
    }

    public CommandCustomHeader readCustomHeader() {
        return this.customHeader;
    }

    public void writeCustomHeader(CommandCustomHeader customHeader) {
        this.customHeader = customHeader;
    }

    public <T extends CommandCustomHeader> T decodeCommandCustomHeader(Class<T> classHeader) throws RemotingCommandException {
        CommandCustomHeader objectHeader;
        try {
            objectHeader = (CommandCustomHeader)classHeader.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (this.extFields != null) {
            Field[] fields;
            for (Field field : fields = this.getClazzFields(classHeader)) {
                String fieldName;
                if (Modifier.isStatic(field.getModifiers()) || (fieldName = field.getName()).startsWith("this")) continue;
                try {
                    Object valueParsed;
                    String value = this.extFields.get(fieldName);
                    if (null == value) {
                        if (this.isFieldNullable(field)) continue;
                        throw new RemotingCommandException("the custom field <" + fieldName + "> is null");
                    }
                    field.setAccessible(true);
                    String type = this.getCanonicalName(field.getType());
                    if (type.equals(STRING_CANONICAL_NAME)) {
                        valueParsed = value;
                    } else if (type.equals(INTEGER_CANONICAL_NAME_1) || type.equals(INTEGER_CANONICAL_NAME_2)) {
                        valueParsed = Integer.parseInt(value);
                    } else if (type.equals(LONG_CANONICAL_NAME_1) || type.equals(LONG_CANONICAL_NAME_2)) {
                        valueParsed = Long.parseLong(value);
                    } else if (type.equals(BOOLEAN_CANONICAL_NAME_1) || type.equals(BOOLEAN_CANONICAL_NAME_2)) {
                        valueParsed = Boolean.parseBoolean(value);
                    } else if (type.equals(DOUBLE_CANONICAL_NAME_1) || type.equals(DOUBLE_CANONICAL_NAME_2)) {
                        valueParsed = Double.parseDouble(value);
                    } else {
                        throw new RemotingCommandException("the custom field <" + fieldName + "> type is not supported");
                    }
                    field.set(objectHeader, valueParsed);
                }
                catch (Throwable e) {
                    log.error("Failed field [{}] decoding", (Object)fieldName, (Object)e);
                }
            }
            objectHeader.checkFields();
        }
        return (T)objectHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field[] getClazzFields(Class<? extends CommandCustomHeader> classHeader) {
        Field[] field = CLASS_HASH_MAP.get(classHeader);
        if (field == null) {
            field = classHeader.getDeclaredFields();
            Map<Class<? extends CommandCustomHeader>, Field[]> map = CLASS_HASH_MAP;
            synchronized (map) {
                CLASS_HASH_MAP.put(classHeader, field);
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFieldNullable(Field field) {
        if (!NULLABLE_FIELD_CACHE.containsKey(field)) {
            CFNotNull annotation = field.getAnnotation(CFNotNull.class);
            Map<Field, Boolean> map = NULLABLE_FIELD_CACHE;
            synchronized (map) {
                NULLABLE_FIELD_CACHE.put(field, annotation == null);
            }
        }
        return NULLABLE_FIELD_CACHE.get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCanonicalName(Class clazz) {
        String name = CANONICAL_NAME_CACHE.get(clazz);
        if (name == null) {
            name = clazz.getCanonicalName();
            Map<Class, String> map = CANONICAL_NAME_CACHE;
            synchronized (map) {
                CANONICAL_NAME_CACHE.put(clazz, name);
            }
        }
        return name;
    }

    public ByteBuffer encode() {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        if (this.body != null) {
            length += this.body.limit();
        }
        ByteBuffer result = ByteBuffer.allocate(4 + length);
        result.putInt(length);
        result.put(RemotingCommand.markProtocolType(headerData.length, this.serializeTypeCurrentRPC));
        result.put(headerData);
        if (this.body != null) {
            result.put(this.body);
        }
        result.flip();
        return result;
    }

    private byte[] headerEncode() {
        this.makeCustomHeaderToNet();
        if (SerializeType.ROCKETMQ == this.serializeTypeCurrentRPC) {
            return RocketMQSerializable.rocketMQProtocolEncode(this);
        }
        return RemotingSerializable.encode(this);
    }

    public void makeCustomHeaderToNet() {
        if (this.customHeader != null) {
            Field[] fields = this.getClazzFields(this.customHeader.getClass());
            if (null == this.extFields) {
                this.extFields = new HashMap();
            }
            for (Field field : fields) {
                String name;
                if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
                Object value = null;
                try {
                    field.setAccessible(true);
                    value = field.get(this.customHeader);
                }
                catch (Exception e) {
                    log.error("Failed to access field [{}]", (Object)name, (Object)e);
                }
                if (value == null) continue;
                this.extFields.put(name, value.toString());
            }
        }
    }

    public ByteBuffer encodeHeader() {
        int bodySize = 0;
        if (null != this.body) {
            bodySize = this.body.limit();
        }
        if (null != this.payload) {
            bodySize = this.payload.readableBytes();
        }
        return this.encodeHeader(bodySize);
    }

    public ByteBuffer encodeHeader(int bodyLength) {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        ByteBuffer result = ByteBuffer.allocate(4 + (length += bodyLength) - bodyLength);
        result.putInt(length);
        result.put(RemotingCommand.markProtocolType(headerData.length, this.serializeTypeCurrentRPC));
        result.put(headerData);
        result.flip();
        return result;
    }

    public void markOnewayRPC() {
        int bits = 2;
        this.flag |= bits;
    }

    @JSONField(serialize=false)
    public boolean isOnewayRPC() {
        int bits = 2;
        return (this.flag & bits) == bits;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @JSONField(serialize=false)
    public RemotingCommandType getType() {
        if (this.isResponseType()) {
            return RemotingCommandType.RESPONSE_COMMAND;
        }
        return RemotingCommandType.REQUEST_COMMAND;
    }

    @JSONField(serialize=false)
    public boolean isResponseType() {
        int bits = 1;
        return (this.flag & bits) == bits;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode language) {
        this.language = language;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @JSONField(serialize=false)
    public ByteBuffer getBody() {
        if (null == this.body) {
            return null;
        }
        return this.body.slice();
    }

    @JSONField(serialize=false)
    public int getBodyLength() {
        if (null == this.body) {
            return 0;
        }
        return this.body.remaining();
    }

    @JSONField(serialize=false)
    public byte[] getByteArrayBody() {
        if (null == this.body) {
            return null;
        }
        if (!RemotingCopyElisionRequestCode.COPY_ELISION_LIST.contains(this.code)) {
            return this.body.array();
        }
        if (this.copied.get()) {
            return this.body.array();
        }
        log.debug("Zero-copy mechanism violated");
        ByteBuffer buffer = ByteBuffer.allocate(this.body.remaining());
        buffer.put(this.body.slice());
        buffer.flip();
        this.body = buffer;
        this.copied.set(true);
        return this.body.array();
    }

    public void setBody(ByteBuffer body) {
        this.body = body;
    }

    public void retain(ReferenceCounted refCnt) {
        refCnt.retain();
        this.refCnt = refCnt;
    }

    public void release() {
        ReferenceCountUtil.release(this.refCnt);
    }

    public void setBody(byte[] body) {
        if (null == body) {
            return;
        }
        this.body = ByteBuffer.wrap(body);
    }

    public ByteBuf encodeFrame() {
        CompositeByteBuf frame = PooledByteBufAllocator.DEFAULT.compositeBuffer();
        ByteBuffer buffer = this.encodeHeader();
        frame.addComponent(true, Unpooled.wrappedBuffer(buffer));
        if (null != this.body) {
            frame.addComponent(true, Unpooled.wrappedBuffer(this.body));
        } else if (null != this.payload) {
            frame.addComponent(true, this.getPayload());
        }
        return frame;
    }

    @JSONField(serialize=false)
    public ByteBuf getPayload() {
        if (null == this.payload) {
            return null;
        }
        return this.payload.slice();
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public boolean payloadAccessible() {
        return null != this.payload && this.payload.refCnt() != 0;
    }

    @JSONField(serialize=false)
    public QoS getQos() {
        return this.qos;
    }

    public void setQos(QoS qos) {
        this.qos = qos;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(HashMap<String, String> extFields) {
        this.extFields = extFields;
    }

    public void addExtField(String key, String value) {
        if (null == this.extFields) {
            this.extFields = new HashMap();
        }
        this.extFields.put(key, value);
    }

    public String toString() {
        return "RemotingCommand [code=" + this.code + ", language=" + (Object)((Object)this.language) + ", version=" + this.version + ", opaque=" + this.opaque + ", flag(B)=" + Integer.toBinaryString(this.flag) + ", remark=" + this.remark + ", extFields=" + this.extFields + ", serializeTypeCurrentRPC=" + (Object)((Object)this.serializeTypeCurrentRPC) + "]";
    }

    public SerializeType getSerializeTypeCurrentRPC() {
        return this.serializeTypeCurrentRPC;
    }

    public void setSerializeTypeCurrentRPC(SerializeType serializeTypeCurrentRPC) {
        this.serializeTypeCurrentRPC = serializeTypeCurrentRPC;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    static {
        String protocol = System.getProperty(SERIALIZE_TYPE_PROPERTY, System.getenv(SERIALIZE_TYPE_ENV));
        if (!RemotingCommand.isBlank(protocol)) {
            try {
                serializeTypeConfigInThisServer = SerializeType.valueOf(protocol);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("parser specified protocol error. protocol=" + protocol, e);
            }
        }
    }
}

