/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.Feature;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.ByteBufferInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class RemotingSerializable {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public static byte[] encode(Object obj) {
        String json = RemotingSerializable.toJson(obj, false);
        if (json != null) {
            return json.getBytes(CHARSET_UTF8);
        }
        return null;
    }

    public static String toJson(Object obj, boolean prettyFormat) {
        return JSON.toJSONString(obj, prettyFormat);
    }

    public static <T> T decode(ByteBuffer data, Class<T> classOfT) {
        try {
            return JSON.parseObject((InputStream)new ByteBufferInputStream(data), classOfT, new Feature[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to deserialize data to JSON object", e);
            return null;
        }
    }

    public static <T> T decode(byte[] data, Class<T> classOfT) {
        String json = new String(data, CHARSET_UTF8);
        return RemotingSerializable.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return JSON.parseObject(json, classOfT);
    }

    public byte[] encode() {
        String json = this.toJson();
        if (json != null) {
            return json.getBytes(CHARSET_UTF8);
        }
        return null;
    }

    public String toJson() {
        return this.toJson(false);
    }

    public String toJson(boolean prettyFormat) {
        return RemotingSerializable.toJson(this, prettyFormat);
    }
}

