/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots;

import com.aliyun.openservices.ots.ClientConfiguration;
import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTS;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.auth.ServiceCredentials;
import com.aliyun.openservices.ots.comm.AsyncClientFutureCallback;
import com.aliyun.openservices.ots.comm.AsyncServiceClient;
import com.aliyun.openservices.ots.comm.ServiceClient;
import com.aliyun.openservices.ots.internal.BatchGetRowCallable;
import com.aliyun.openservices.ots.internal.BatchGetRowExecutionContext;
import com.aliyun.openservices.ots.internal.BatchWriteRowCallable;
import com.aliyun.openservices.ots.internal.BatchWriteRowExecutionContext;
import com.aliyun.openservices.ots.internal.CreateTableCallable;
import com.aliyun.openservices.ots.internal.DeleteRowCallable;
import com.aliyun.openservices.ots.internal.DeleteTableCallable;
import com.aliyun.openservices.ots.internal.DescribeTableCallable;
import com.aliyun.openservices.ots.internal.GetRangeCallable;
import com.aliyun.openservices.ots.internal.GetRowCallable;
import com.aliyun.openservices.ots.internal.ListTableCallable;
import com.aliyun.openservices.ots.internal.OTSAsyncDataOperation;
import com.aliyun.openservices.ots.internal.OTSAsyncTableOperation;
import com.aliyun.openservices.ots.internal.OTSExecutionContext;
import com.aliyun.openservices.ots.internal.OTSRetryStrategy;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.PutRowCallable;
import com.aliyun.openservices.ots.internal.UpdateRowCallable;
import com.aliyun.openservices.ots.internal.UpdateTableCallable;
import com.aliyun.openservices.ots.model.BatchGetRowRequest;
import com.aliyun.openservices.ots.model.BatchGetRowResult;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.CreateTableRequest;
import com.aliyun.openservices.ots.model.CreateTableResult;
import com.aliyun.openservices.ots.model.DeleteRowRequest;
import com.aliyun.openservices.ots.model.DeleteRowResult;
import com.aliyun.openservices.ots.model.DeleteTableRequest;
import com.aliyun.openservices.ots.model.DeleteTableResult;
import com.aliyun.openservices.ots.model.DescribeTableRequest;
import com.aliyun.openservices.ots.model.DescribeTableResult;
import com.aliyun.openservices.ots.model.GetRangeRequest;
import com.aliyun.openservices.ots.model.GetRangeResult;
import com.aliyun.openservices.ots.model.GetRowRequest;
import com.aliyun.openservices.ots.model.GetRowResult;
import com.aliyun.openservices.ots.model.ListTableResult;
import com.aliyun.openservices.ots.model.OTSBasicFuture;
import com.aliyun.openservices.ots.model.PutRowRequest;
import com.aliyun.openservices.ots.model.PutRowResult;
import com.aliyun.openservices.ots.model.RangeIteratorParameter;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowIterator;
import com.aliyun.openservices.ots.model.UpdateRowRequest;
import com.aliyun.openservices.ots.model.UpdateRowResult;
import com.aliyun.openservices.ots.model.UpdateTableRequest;
import com.aliyun.openservices.ots.model.UpdateTableResult;
import com.aliyun.openservices.ots.utils.CodingUtils;
import com.aliyun.openservices.ots.utils.Preconditions;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class OTSClient
implements OTS {
    private String endpoint;
    private String instanceName;
    private ServiceCredentials credentials;
    private ServiceClient client;
    private ScheduledExecutorService retryExecutor;
    private OTSServiceConfiguration serviceConfig;
    private OTSAsyncTableOperation asyncTableOp;
    private OTSAsyncDataOperation asyncDataOp;
    private OTSRetryStrategy retryStrategy;
    private Random random = new Random();

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, String stsToken) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null, null, stsToken);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, OTSServiceConfiguration otsConfig) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, otsConfig, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, OTSServiceConfiguration otsConfig, String stsToken) {
        CodingUtils.assertStringNotNullOrEmpty(endpoint, "endpoint");
        CodingUtils.assertStringNotNullOrEmpty(accessKeyId, "accessKeyId");
        CodingUtils.assertStringNotNullOrEmpty(accessKeySecret, "accessKeySecret");
        CodingUtils.assertStringNotNullOrEmpty(instanceName, "instanceName");
        try {
            Preconditions.checkArgument(instanceName.length() == instanceName.getBytes("utf-8").length, "InstanceName should not have multibyte character.");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ClientException("UnsupportedEncoding", ex);
        }
        if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointProtocolInvalid"));
        }
        this.endpoint = endpoint;
        this.credentials = new ServiceCredentials(accessKeyId, accessKeySecret, stsToken);
        if (config == null) {
            config = new ClientConfiguration();
        }
        this.client = new AsyncServiceClient(config);
        this.retryExecutor = Executors.newScheduledThreadPool(config.getRetryThreadCount());
        this.serviceConfig = otsConfig != null ? otsConfig : new OTSServiceConfiguration();
        this.retryStrategy = this.serviceConfig.getRetryStrategy();
        this.instanceName = instanceName;
        this.asyncTableOp = new OTSAsyncTableOperation(this.endpoint, this.instanceName, this.client, this.credentials, this.serviceConfig);
        this.asyncDataOp = new OTSAsyncDataOperation(this.endpoint, this.instanceName, this.client, this.credentials, this.serviceConfig);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    private OTSAsyncTableOperation getAsyncTableOperation() {
        return this.asyncTableOp;
    }

    private OTSAsyncDataOperation getAsyncDataOperation() {
        return this.asyncDataOp;
    }

    private OTSTraceLogger getOTSTraceLogger() {
        String traceId = new UUID(this.random.nextLong(), new Random().nextLong()).toString();
        OTSTraceLogger traceLogger = new OTSTraceLogger(traceId, this.serviceConfig.getTimeThresholdOfTraceLogger());
        return traceLogger;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.asyncTableOp.setExtraHeaders(extraHeaders);
        this.asyncDataOp.setExtraHeaders(extraHeaders);
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest createTableRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(createTableRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<CreateTableRequest, CreateTableResult> executionContext = new OTSExecutionContext<CreateTableRequest, CreateTableResult>(createTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("CreateTable", executionContext));
        executionContext.setCallable(new CreateTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return (CreateTableResult)future.get();
    }

    @Override
    public ListTableResult listTable() throws OTSException, ClientException {
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext executionContext = new OTSExecutionContext(null, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("ListTable", executionContext));
        executionContext.setCallable(new ListTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return (ListTableResult)future.get();
    }

    @Override
    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(describeTableRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<DescribeTableRequest, DescribeTableResult> executionContext = new OTSExecutionContext<DescribeTableRequest, DescribeTableResult>(describeTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("DescribeTable", executionContext));
        executionContext.setCallable(new DescribeTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return (DescribeTableResult)future.get();
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(deleteTableRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<DeleteTableRequest, DeleteTableResult> executionContext = new OTSExecutionContext<DeleteTableRequest, DeleteTableResult>(deleteTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("DeleteTable", executionContext));
        executionContext.setCallable(new DeleteTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return (DeleteTableResult)future.get();
    }

    @Override
    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(updateTableRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<UpdateTableRequest, UpdateTableResult> executionContext = new OTSExecutionContext<UpdateTableRequest, UpdateTableResult>(updateTableRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("UpdateTable", executionContext));
        executionContext.setCallable(new UpdateTableCallable(this.getAsyncTableOperation(), executionContext));
        executionContext.getCallable().call();
        return (UpdateTableResult)future.get();
    }

    @Override
    public GetRowResult getRow(GetRowRequest getRowRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(getRowRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<GetRowRequest, GetRowResult> executionContext = new OTSExecutionContext<GetRowRequest, GetRowResult>(getRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("GetRow", executionContext));
        executionContext.setCallable(new GetRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return (GetRowResult)future.get();
    }

    @Override
    public PutRowResult putRow(PutRowRequest putRowRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(putRowRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<PutRowRequest, PutRowResult> executionContext = new OTSExecutionContext<PutRowRequest, PutRowResult>(putRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("PutRow", executionContext));
        executionContext.setCallable(new PutRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return (PutRowResult)future.get();
    }

    @Override
    public UpdateRowResult updateRow(UpdateRowRequest updateRowRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(updateRowRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<UpdateRowRequest, UpdateRowResult> executionContext = new OTSExecutionContext<UpdateRowRequest, UpdateRowResult>(updateRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("UpdateRow", executionContext));
        executionContext.setCallable(new UpdateRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return (UpdateRowResult)future.get();
    }

    @Override
    public DeleteRowResult deleteRow(DeleteRowRequest deleteRowRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(deleteRowRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<DeleteRowRequest, DeleteRowResult> executionContext = new OTSExecutionContext<DeleteRowRequest, DeleteRowResult>(deleteRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("DeleteRow", executionContext));
        executionContext.setCallable(new DeleteRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return (DeleteRowResult)future.get();
    }

    @Override
    public BatchGetRowResult batchGetRow(BatchGetRowRequest batchGetRowRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(batchGetRowRequest);
        OTSBasicFuture<BatchGetRowResult> future = new OTSBasicFuture<BatchGetRowResult>(null);
        BatchGetRowExecutionContext executionContext = new BatchGetRowExecutionContext(batchGetRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<BatchGetRowResult>("BatchGetRow", executionContext));
        executionContext.setCallable(new BatchGetRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return future.get();
    }

    @Override
    public BatchWriteRowResult batchWriteRow(BatchWriteRowRequest batchWriteRowRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(batchWriteRowRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        BatchWriteRowExecutionContext executionContext = new BatchWriteRowExecutionContext(batchWriteRowRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback<BatchWriteRowResult>("BatchWriteRow", executionContext));
        executionContext.setCallable(new BatchWriteRowCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return (BatchWriteRowResult)future.get();
    }

    @Override
    public GetRangeResult getRange(GetRangeRequest getRangeRequest) throws OTSException, ClientException {
        Preconditions.checkNotNull(getRangeRequest);
        OTSBasicFuture future = new OTSBasicFuture(null);
        OTSExecutionContext<GetRangeRequest, GetRangeResult> executionContext = new OTSExecutionContext<GetRangeRequest, GetRangeResult>(getRangeRequest, future, this.getOTSTraceLogger(), this.retryStrategy, this.retryExecutor);
        executionContext.setAsyncClientCallback(new AsyncClientFutureCallback("GetRange", executionContext));
        executionContext.setCallable(new GetRangeCallable(this.getAsyncDataOperation(), executionContext));
        executionContext.getCallable().call();
        return (GetRangeResult)future.get();
    }

    @Override
    public Iterator<Row> createRangeIterator(RangeIteratorParameter rangeIteratorParameter) throws OTSException, ClientException {
        return new RowIterator(this, rangeIteratorParameter);
    }

    @Override
    public void shutdown() {
        this.retryExecutor.shutdown();
        this.client.shutdown();
    }
}

