/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.PartialResultFailedException;
import com.aliyun.openservices.ots.internal.BatchWriteRowExecutionContext;
import com.aliyun.openservices.ots.internal.OTSAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.log.LogUtil;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.OTSResult;
import com.aliyun.openservices.ots.model.OTSResultFactory;
import com.aliyun.openservices.ots.parser.ResultParser;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import java.util.List;
import java.util.Map;

class BatchWriteRowAsyncResponseConsumer
extends OTSAsyncResponseConsumer<BatchWriteRowResult> {
    private BatchWriteRowExecutionContext executionContext;

    public BatchWriteRowAsyncResponseConsumer(ResultParser resultParser, BatchWriteRowExecutionContext executionContext) {
        super(resultParser, executionContext.getTraceLogger());
        this.executionContext = executionContext;
    }

    BatchWriteRowResult mergeResult(BatchWriteRowResult lastResult, BatchWriteRowResult result) {
        BatchWriteRowResult.RowStatus rowResult;
        int idx;
        List<BatchWriteRowResult.RowStatus> rowResultList;
        List<BatchWriteRowResult.RowStatus> lastRowResultList;
        OTSResult meta = new OTSResult(result.getRequestID());
        meta.setTraceId(this.traceLogger.getTraceId());
        BatchWriteRowResult mergedResult = new BatchWriteRowResult(meta);
        Map<String, List<BatchWriteRowResult.RowStatus>> lastRowResultMap = lastResult.getPutRowStatus();
        Map<String, List<BatchWriteRowResult.RowStatus>> rowResultMap = result.getPutRowStatus();
        for (String tableName : lastRowResultMap.keySet()) {
            lastRowResultList = lastRowResultMap.get(tableName);
            rowResultList = rowResultMap.get(tableName);
            idx = 0;
            for (BatchWriteRowResult.RowStatus lastRowResult : lastRowResultList) {
                if (lastRowResult.isSucceed()) {
                    mergedResult.addPutRowResult(lastRowResult);
                    continue;
                }
                rowResult = rowResultList.get(idx);
                ++idx;
                if (rowResult.isSucceed()) {
                    mergedResult.addPutRowResult(new BatchWriteRowResult.RowStatus(tableName, rowResult.getConsumedCapacity(), lastRowResult.getIndex()));
                    continue;
                }
                mergedResult.addPutRowResult(new BatchWriteRowResult.RowStatus(tableName, rowResult.getError(), lastRowResult.getIndex()));
            }
        }
        lastRowResultMap = lastResult.getUpdateRowStatus();
        rowResultMap = result.getUpdateRowStatus();
        for (String tableName : lastRowResultMap.keySet()) {
            lastRowResultList = lastRowResultMap.get(tableName);
            rowResultList = rowResultMap.get(tableName);
            idx = 0;
            for (BatchWriteRowResult.RowStatus lastRowResult : lastRowResultList) {
                if (lastRowResult.isSucceed()) {
                    mergedResult.addUpdateRowResult(lastRowResult);
                    continue;
                }
                rowResult = rowResultList.get(idx);
                ++idx;
                if (rowResult.isSucceed()) {
                    mergedResult.addUpdateRowResult(new BatchWriteRowResult.RowStatus(tableName, rowResult.getConsumedCapacity(), lastRowResult.getIndex()));
                    continue;
                }
                mergedResult.addUpdateRowResult(new BatchWriteRowResult.RowStatus(tableName, rowResult.getError(), lastRowResult.getIndex()));
            }
        }
        lastRowResultMap = lastResult.getDeleteRowStatus();
        rowResultMap = result.getDeleteRowStatus();
        for (String tableName : lastRowResultMap.keySet()) {
            lastRowResultList = lastRowResultMap.get(tableName);
            rowResultList = rowResultMap.get(tableName);
            idx = 0;
            for (BatchWriteRowResult.RowStatus lastRowResult : lastRowResultList) {
                if (lastRowResult.isSucceed()) {
                    mergedResult.addDeleteRowResult(lastRowResult);
                    continue;
                }
                rowResult = rowResultList.get(idx);
                ++idx;
                if (rowResult.isSucceed()) {
                    mergedResult.addDeleteRowResult(new BatchWriteRowResult.RowStatus(tableName, rowResult.getConsumedCapacity(), lastRowResult.getIndex()));
                    continue;
                }
                mergedResult.addDeleteRowResult(new BatchWriteRowResult.RowStatus(tableName, rowResult.getError(), lastRowResult.getIndex()));
            }
        }
        return mergedResult;
    }

    @Override
    protected BatchWriteRowResult parseResult() throws Exception {
        OTSException ex;
        ResponseContentWithMeta responseContent = this.getResponseContentWithMeta();
        OtsProtocol2.BatchWriteRowResponse batchWriteRowResponse = (OtsProtocol2.BatchWriteRowResponse)responseContent.getMessage();
        BatchWriteRowResult result = OTSResultFactory.createBatchWriteRowResult(responseContent, batchWriteRowResponse);
        BatchWriteRowResult lastResult = this.executionContext.getLastResult();
        if (lastResult != null) {
            result = this.mergeResult(lastResult, result);
        }
        List<BatchWriteRowResult.RowStatus> failedRowsOfPut = result.getFailedRowsOfPut();
        List<BatchWriteRowResult.RowStatus> failedRowsOfUpdate = result.getFailedRowsOfUpdate();
        List<BatchWriteRowResult.RowStatus> failedRowsOfDelete = result.getFailedRowsOfDelete();
        if (failedRowsOfPut.isEmpty() && failedRowsOfUpdate.isEmpty() && failedRowsOfDelete.isEmpty()) {
            return result;
        }
        PartialResultFailedException partialEx = new PartialResultFailedException(null, result.getRequestID(), result);
        for (BatchWriteRowResult.RowStatus rowResult : failedRowsOfPut) {
            ex = new OTSException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), result.getRequestID(), 0);
            partialEx.addError(ex);
            LogUtil.logOnFailed(this.executionContext, ex, result.getRequestID());
        }
        for (BatchWriteRowResult.RowStatus rowResult : failedRowsOfUpdate) {
            ex = new OTSException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), result.getRequestID(), 0);
            partialEx.addError(ex);
            LogUtil.logOnFailed(this.executionContext, ex, result.getRequestID());
        }
        for (BatchWriteRowResult.RowStatus rowResult : failedRowsOfDelete) {
            ex = new OTSException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), result.getRequestID(), 0);
            partialEx.addError(ex);
            LogUtil.logOnFailed(this.executionContext, ex, result.getRequestID());
        }
        throw partialEx;
    }
}

