/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.auth.ServiceCredentials;
import com.aliyun.openservices.ots.comm.ExecutionContext;
import com.aliyun.openservices.ots.comm.OTSUri;
import com.aliyun.openservices.ots.comm.RequestMessage;
import com.aliyun.openservices.ots.comm.ServiceClient;
import com.aliyun.openservices.ots.internal.OTSAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.OTSCompressUtil;
import com.aliyun.openservices.ots.internal.OTSContentMD5ResponseHandler;
import com.aliyun.openservices.ots.internal.OTSDeflateResponseHandler;
import com.aliyun.openservices.ots.internal.OTSErrorResponseHandler;
import com.aliyun.openservices.ots.internal.OTSRequestSigner;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.OTSValidationResponseHandler;
import com.aliyun.openservices.ots.utils.BinaryUtil;
import com.aliyun.openservices.ots.utils.CodingUtils;
import com.aliyun.openservices.ots.utils.DateUtil;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.zip.Deflater;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OTSOperation {
    protected Logger logger = LoggerFactory.getLogger(OTSOperation.class);
    private String instanceName;
    private ServiceClient client;
    private ServiceCredentials credentials;
    private OTSServiceConfiguration serviceConfig;
    private Map<String, String> extraHeaders;

    public OTSOperation(String instanceName, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        CodingUtils.assertParameterNotNull(instanceName, "instanceName");
        CodingUtils.assertParameterNotNull(client, "client");
        CodingUtils.assertParameterNotNull(credentials, "credentials");
        CodingUtils.assertParameterNotNull(serviceConfig, "serviceConfig");
        this.instanceName = instanceName;
        this.client = client;
        this.credentials = credentials;
        this.serviceConfig = serviceConfig;
    }

    private URI buildURI(OTSUri actionUri, Map<String, String> queryParameter) {
        if (queryParameter == null || queryParameter.isEmpty()) {
            return actionUri.getUri();
        }
        try {
            URIBuilder builder = new URIBuilder(actionUri.getUri());
            for (Map.Entry<String, String> entry : queryParameter.entrySet()) {
                builder.addParameter(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected <Res> void asyncInvokePost(OTSUri actionURI, Map<String, String> queryParameters, Message message, OTSTraceLogger traceLogger, OTSAsyncResponseConsumer<Res> consumer, FutureCallback<Res> callback) throws ClientException {
        byte[] content;
        URI uri = this.buildURI(actionURI, queryParameters);
        HttpPost request = new HttpPost(uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Operation: {}, PBRequestMessage: {}, TraceId: {}", new Object[]{actionURI.getAction(), message.toString(), traceLogger.getTraceId()});
        }
        if ((content = message.toByteArray()) == null) {
            content = new byte[]{};
        }
        byte[] dataToSend = null;
        if (this.serviceConfig.isEnableRequestCompression()) {
            try {
                dataToSend = OTSCompressUtil.compress(new ByteArrayInputStream(content), new Deflater());
            }
            catch (IOException e) {
                throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("RequestCompressFail", e.getMessage()));
            }
            request.addHeader("x-ots-request-compress-type", "deflate");
            request.addHeader("x-ots-request-compress-size", Integer.toString(content.length));
        } else {
            dataToSend = content;
        }
        request.setEntity((HttpEntity)new ByteArrayEntity(dataToSend));
        String contentMd5 = BinaryUtil.toBase64String(BinaryUtil.calculateMd5(dataToSend));
        RequestMessage requestMessage = new RequestMessage((HttpRequestBase)request);
        requestMessage.setQueryParameters(queryParameters);
        requestMessage.setActionUri(actionURI);
        requestMessage.setContentLength(content.length);
        this.addRequiredHeaders(requestMessage, contentMd5, traceLogger.getTraceId());
        this.client.asyncSendRequest(requestMessage, this.createContext(actionURI.getAction()), consumer, callback, traceLogger);
    }

    private ExecutionContext createContext(String otsAction) {
        ExecutionContext ec = new ExecutionContext();
        ec.setCharset("utf-8");
        ec.setSigner(new OTSRequestSigner(otsAction, this.credentials));
        if (this.serviceConfig.isEnableResponseContentMD5Checking()) {
            ec.getResponseHandlers().add(new OTSContentMD5ResponseHandler());
        }
        ec.getResponseHandlers().add(new OTSDeflateResponseHandler());
        ec.getResponseHandlers().add(new OTSErrorResponseHandler());
        if (this.serviceConfig.isEnableResponseValidation()) {
            ec.getResponseHandlers().add(new OTSValidationResponseHandler(this.credentials, otsAction));
        }
        return ec;
    }

    private void addRequiredHeaders(RequestMessage request, String contentMd5, String traceId) {
        request.addHeader("x-ots-contentmd5", contentMd5);
        request.addHeader("x-ots-apiversion", "2014-08-08");
        request.addHeader("x-ots-instancename", this.instanceName);
        request.addHeader("x-ots-date", DateUtil.getCurrentRfc822Date());
        request.addHeader("x-ots-accesskeyid", this.credentials.getAccessKeyId());
        if (this.credentials.getStsToken() != null && !this.credentials.getStsToken().isEmpty()) {
            request.addHeader("x-ots-ststoken", this.credentials.getStsToken());
        }
        if (this.serviceConfig.isEnableResponseCompression()) {
            request.addHeader("x-ots-response-compress-type", "deflate");
        }
        request.addHeader("x-ots-sdk-traceid", traceId);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        if (this.extraHeaders != null) {
            for (Map.Entry<String, String> entry : this.extraHeaders.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.extraHeaders = extraHeaders;
    }
}

