/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.comm.ResponseMessage;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.OTSResult;
import com.aliyun.openservices.ots.parser.ResultParseException;
import com.aliyun.openservices.ots.parser.ResultParser;
import com.aliyun.openservices.ots.utils.ResourceManager;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UninitializedMessageException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBufferParser
implements ResultParser {
    private static Logger logger = LoggerFactory.getLogger(ProtocolBufferParser.class);
    private Message message;
    private String traceId;

    public ProtocolBufferParser(Message message, String traceId) {
        this.message = message;
        this.traceId = traceId;
    }

    @Override
    public Object getObject(ResponseMessage response) throws ResultParseException {
        Map<String, String> headers = response.getHeadersMap();
        String requestId = headers.get("x-ots-requestid");
        if (requestId == null) {
            throw new ClientException("The required header is missing: x-ots-requestid");
        }
        try {
            Message result = this.message.newBuilderForType().mergeFrom(response.getContent()).buildPartial();
            if (!result.isInitialized()) {
                throw new UninitializedMessageException((MessageLite)result).asInvalidProtocolBufferException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("PBResponseMessage: {}, RequestId: {}, TraceId: {}", new Object[]{result.toString(), requestId, this.traceId});
            }
            return new ResponseContentWithMeta(result, new OTSResult(headers.get("x-ots-requestid")));
        }
        catch (Exception e) {
            throw new ResultParseException(ResourceManager.getInstance("common").getString("FailedToParseResponse"), e);
        }
    }
}

