/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.writer;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSAsync;
import com.aliyun.openservices.ots.internal.OTSCallback;
import com.aliyun.openservices.ots.internal.writer.FlushCallback;
import com.aliyun.openservices.ots.internal.writer.RowChangeEvent;
import com.aliyun.openservices.ots.internal.writer.WriteRPCBuffer;
import com.aliyun.openservices.ots.internal.writer.WriterConfig;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.OTSContext;
import com.aliyun.openservices.ots.model.RowChange;
import com.lmax.disruptor.EventHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowChangeEventHandler
implements EventHandler<RowChangeEvent> {
    private Logger logger = LoggerFactory.getLogger(RowChangeEventHandler.class);
    private OTSAsync ots;
    private WriteRPCBuffer buffer;
    private int concurrency;
    private Semaphore semaphore;
    private OTSCallback<RowChange, ConsumedCapacity> callback;
    private Executor executor;
    private AtomicLong totalRequestCount;

    public RowChangeEventHandler(OTSAsync ots, WriterConfig writerConfig, OTSCallback<RowChange, ConsumedCapacity> callback, Executor executor) {
        this.ots = ots;
        this.buffer = new WriteRPCBuffer(writerConfig);
        this.concurrency = writerConfig.getConcurrency();
        this.semaphore = new Semaphore(this.concurrency);
        this.callback = callback;
        this.executor = executor;
        this.totalRequestCount = new AtomicLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(RowChangeEvent rowChangeEvent, long sequence, boolean endOfBatch) throws Exception {
        BatchWriteRowRequest request = null;
        boolean shouldWaitFlush = false;
        ReentrantLock lock = null;
        Condition flushCond = null;
        if (rowChangeEvent.type == RowChangeEvent.EventType.FLUSH) {
            this.logger.debug("FlushSignal with QueueSize: {}", (Object)this.buffer.getTotalRowsCount());
            if (this.buffer.getTotalRowsCount() > 0) {
                request = this.buffer.makeRequest();
                this.buffer.clear();
            }
            shouldWaitFlush = true;
            lock = rowChangeEvent.lock;
            flushCond = rowChangeEvent.condition;
        } else {
            final RowChange rowChange = rowChangeEvent.rowChange;
            boolean succeed = this.buffer.appendRowChange(rowChange);
            if (!succeed) {
                request = this.buffer.makeRequest();
                this.buffer.clear();
                succeed = this.buffer.appendRowChange(rowChange);
                if (!succeed) {
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            RowChangeEventHandler.this.callback.onFailed(new OTSContext<RowChange, Object>(rowChange, null), new ClientException("Can not even append only one row into buffer."));
                        }
                    });
                }
            }
        }
        if (request != null) {
            this.semaphore.acquire();
            this.logger.debug("Acquire semaphore, start send async request.");
            final BatchWriteRowRequest finalRequest = request;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    RowChangeEventHandler.this.totalRequestCount.incrementAndGet();
                    RowChangeEventHandler.this.ots.batchWriteRow(finalRequest, new FlushCallback<BatchWriteRowRequest, BatchWriteRowResult>(RowChangeEventHandler.this.ots, new AtomicInteger(1), RowChangeEventHandler.this.semaphore, RowChangeEventHandler.this.callback, RowChangeEventHandler.this.executor));
                }
            });
        }
        if (shouldWaitFlush) {
            this.waitFlush();
            lock.lock();
            try {
                flushCond.signal();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void waitFlush() throws InterruptedException {
        this.logger.debug("Wait flush.");
        for (int i = 0; i < this.concurrency; ++i) {
            this.semaphore.acquire();
            this.logger.debug("Wait flush: {}, {}", (Object)i, (Object)this.concurrency);
        }
        this.semaphore.release(this.concurrency);
        this.logger.debug("Wait flush finished.");
    }

    public long getTotalRPCCount() {
        return this.totalRequestCount.get();
    }
}

