/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.core;

import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordResponse;
import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.core.exceptions.ShardEndReachedException;
import com.aliyun.openservices.ots.internal.streamclient.model.ShardInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(DataFetcher.class);
    private String checkpointValue;
    private SyncClientInterface ots;
    private final String shardId;
    private final String streamId;
    private boolean isInitialized;

    public DataFetcher(SyncClientInterface ots, ShardInfo shardInfo) {
        this.shardId = shardInfo.getShardId();
        this.streamId = shardInfo.getStreamId();
        this.ots = ots;
    }

    public GetStreamRecordResponse getRecords(int maxRecords) throws DependencyException, StreamClientException {
        if (!this.isInitialized) {
            throw new StreamClientException("DataFetcherNotInitialized");
        }
        GetStreamRecordResponse result = null;
        try {
            GetStreamRecordRequest request = new GetStreamRecordRequest(this.getShardIterator());
            request.setLimit(maxRecords);
            result = this.ots.getStreamRecord(request);
            this.updateCheckpoint(result.getNextShardIterator());
        }
        catch (TableStoreException ex) {
            throw new DependencyException(ex.toString(), ex);
        }
        return result;
    }

    public void initialize(String initialCheckpoint) throws StreamClientException {
        if (this.isInitialized) {
            throw new StreamClientException("DataFetcherAlreadyInitialized");
        }
        this.checkpointValue = initialCheckpoint;
        this.isInitialized = true;
    }

    public void updateCheckpoint(String checkpointValue) throws StreamClientException {
        if (!this.isInitialized) {
            throw new StreamClientException("DataFetcherNotInitialized");
        }
        this.checkpointValue = checkpointValue;
    }

    String getShardIterator() throws DependencyException, StreamClientException {
        if (!this.isInitialized) {
            throw new StreamClientException("DataFetcherNotInitialized");
        }
        try {
            if (this.checkpointValue.equals("SHARD_END")) {
                throw new ShardEndReachedException("CheckpointReachedShardEnd");
            }
            if (this.checkpointValue.equals("TRIM_HORIZON")) {
                GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest(this.streamId, this.shardId);
                return this.ots.getShardIterator(getShardIteratorRequest).getShardIterator();
            }
            return this.checkpointValue;
        }
        catch (TableStoreException ex) {
            throw new DependencyException(ex.toString(), ex);
        }
    }
}

