/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.core.task;

import com.aliyun.openservices.ots.internal.streamclient.core.task.ITask;
import com.aliyun.openservices.ots.internal.streamclient.core.task.TaskResult;
import com.aliyun.openservices.ots.internal.streamclient.core.task.TaskType;
import com.aliyun.openservices.ots.internal.streamclient.model.IRetryStrategy;
import com.aliyun.openservices.ots.internal.streamclient.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingTaskDecorator
implements ITask {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingTaskDecorator.class);
    private final IRetryStrategy.RetryableAction actionName;
    private final IRetryStrategy retryStrategy;
    private final ITask task;

    public RetryingTaskDecorator(IRetryStrategy.RetryableAction actionName, IRetryStrategy retryStrategy, ITask task) {
        this.actionName = actionName;
        this.retryStrategy = retryStrategy;
        this.task = task;
    }

    @Override
    public TaskResult call() {
        Exception exception;
        int retries = 0;
        while (true) {
            exception = null;
            try {
                TaskResult taskResult = this.task.call();
                if (taskResult.getException() == null) {
                    return taskResult;
                }
                exception = taskResult.getException();
            }
            catch (Exception ex) {
                exception = ex;
            }
            if (!this.retryStrategy.shouldRetry(this.actionName, exception, retries)) break;
            LOG.debug("Retry, Action: {}, Exception: {}, Retries: {}", new Object[]{this.actionName, exception, retries});
            TimeUtils.sleepMillis(this.retryStrategy.getBackoffTimeMillis(this.actionName, exception, retries));
            ++retries;
        }
        LOG.debug("NoRetry, Action: {}, Exception: {}, Retries: {}", new Object[]{this.actionName, exception, retries});
        return new TaskResult(exception);
    }

    @Override
    public TaskType getTaskType() {
        return this.task.getTaskType();
    }
}

