/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.ReservedThroughput;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.condition.ColumnCondition;
import com.alicloud.openservices.tablestore.model.condition.CompositeColumnValueCondition;
import com.alicloud.openservices.tablestore.model.condition.SingleColumnValueCondition;
import com.aliyun.openservices.ots.internal.streamclient.lease.Lease;
import java.util.Arrays;

abstract class AbstractLeaseSerializer<T extends Lease> {
    protected static final String STREAM_ID = "StreamId";
    protected static final String STATUS_TYPE = "StatusType";
    protected static final String STATUS_VALUE = "StatusValue";
    protected static final String LEASE_KEY = "LeaseKey";
    protected static final String LEASE_OWNER = "LeaseOwner";
    protected static final String LEASE_COUNTER = "LeaseCounter";
    protected static final String LEASE_STEALER = "LeaseStealer";
    protected final String statusTableName;
    protected final String dataTableStreamId;

    AbstractLeaseSerializer(String statusTableName, String dataTableStreamId) {
        this.statusTableName = statusTableName;
        this.dataTableStreamId = dataTableStreamId;
    }

    TableMeta getTableMeta() {
        TableMeta tableMeta = new TableMeta(this.statusTableName);
        tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(STREAM_ID, PrimaryKeyType.STRING));
        tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(STATUS_TYPE, PrimaryKeyType.STRING));
        tableMeta.addPrimaryKeyColumn(new PrimaryKeySchema(STATUS_VALUE, PrimaryKeyType.STRING));
        return tableMeta;
    }

    CreateTableRequest getCreateTableRequest(int readCU, int writeCU, int ttl) {
        TableMeta meta = this.getTableMeta();
        TableOptions options = new TableOptions(ttl, 1);
        CreateTableRequest request = new CreateTableRequest(meta, options);
        request.setReservedThroughput(new ReservedThroughput(readCU, writeCU));
        return request;
    }

    PrimaryKey getPrimaryKey(PrimaryKeyValue leaseKey) {
        PrimaryKey primaryKey = new PrimaryKey(Arrays.asList(new PrimaryKeyColumn(STREAM_ID, PrimaryKeyValue.fromString((String)this.dataTableStreamId)), new PrimaryKeyColumn(STATUS_TYPE, PrimaryKeyValue.fromString((String)LEASE_KEY)), new PrimaryKeyColumn(STATUS_VALUE, leaseKey)));
        return primaryKey;
    }

    RangeIteratorParameter getRangeIteratorParameter() {
        RangeRowQueryCriteria criteria = new RangeRowQueryCriteria(this.statusTableName);
        criteria.setMaxVersions(1);
        criteria.setInclusiveStartPrimaryKey(this.getPrimaryKey(PrimaryKeyValue.INF_MIN));
        criteria.setExclusiveEndPrimaryKey(this.getPrimaryKey(PrimaryKeyValue.INF_MAX));
        RangeIteratorParameter parameter = new RangeIteratorParameter(criteria);
        return parameter;
    }

    DeleteRowRequest getDeleteRowRequest(String leaseKey) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)leaseKey));
        RowDeleteChange change = new RowDeleteChange(this.statusTableName, pk);
        DeleteRowRequest request = new DeleteRowRequest();
        request.setRowChange(change);
        return request;
    }

    GetRowRequest getGetRowRequest(String leaseKey) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)leaseKey));
        SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(this.statusTableName, pk);
        criteria.setMaxVersions(1);
        GetRowRequest request = new GetRowRequest(criteria);
        return request;
    }

    UpdateRowRequest getUpdateRowRequestForRenew(T lease) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)((Lease)lease).getLeaseKey()));
        RowUpdateChange change = new RowUpdateChange(this.statusTableName, pk);
        change.put(LEASE_COUNTER, ColumnValue.fromLong((long)(((Lease)lease).getLeaseCounter() + 1L)));
        change.setCondition(this.getCounterCheckCondition(((Lease)lease).getLeaseCounter()));
        UpdateRowRequest request = new UpdateRowRequest(change);
        return request;
    }

    UpdateRowRequest getUpdateRowRequestForTake(T lease, String newOwner) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)((Lease)lease).getLeaseKey()));
        RowUpdateChange change = new RowUpdateChange(this.statusTableName, pk);
        change.put(LEASE_COUNTER, ColumnValue.fromLong((long)(((Lease)lease).getLeaseCounter() + 1L)));
        change.put(LEASE_OWNER, ColumnValue.fromString((String)newOwner));
        change.put(LEASE_STEALER, ColumnValue.fromString((String)""));
        change.setCondition(this.getCounterCheckCondition(((Lease)lease).getLeaseCounter()));
        UpdateRowRequest request = new UpdateRowRequest(change);
        return request;
    }

    UpdateRowRequest getUpdateRowRequestForSteal(T lease, String stealer) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)((Lease)lease).getLeaseKey()));
        RowUpdateChange change = new RowUpdateChange(this.statusTableName, pk);
        change.put(LEASE_STEALER, ColumnValue.fromString((String)stealer));
        SingleColumnValueCondition ownerCondition = new SingleColumnValueCondition(LEASE_OWNER, SingleColumnValueCondition.CompareOperator.EQUAL, ColumnValue.fromString((String)((Lease)lease).getLeaseOwner()));
        ownerCondition.setPassIfMissing(false);
        ownerCondition.setLatestVersionsOnly(true);
        SingleColumnValueCondition stealerCondition = new SingleColumnValueCondition(LEASE_STEALER, SingleColumnValueCondition.CompareOperator.EQUAL, ColumnValue.fromString((String)""));
        stealerCondition.setPassIfMissing(true);
        stealerCondition.setLatestVersionsOnly(true);
        CompositeColumnValueCondition compositeCond = new CompositeColumnValueCondition(CompositeColumnValueCondition.LogicOperator.AND);
        compositeCond.addCondition((ColumnCondition)ownerCondition);
        compositeCond.addCondition((ColumnCondition)stealerCondition);
        Condition condition = new Condition();
        condition.setColumnCondition((ColumnCondition)compositeCond);
        change.setCondition(condition);
        UpdateRowRequest request = new UpdateRowRequest(change);
        return request;
    }

    UpdateRowRequest getUpdateRowRequestForTransfer(T lease) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)((Lease)lease).getLeaseKey()));
        RowUpdateChange change = new RowUpdateChange(this.statusTableName, pk);
        change.put(LEASE_COUNTER, ColumnValue.fromLong((long)(((Lease)lease).getLeaseCounter() + 1L)));
        change.put(LEASE_OWNER, ColumnValue.fromString((String)((Lease)lease).getLeaseStealer()));
        change.setCondition(this.getCounterCheckCondition(((Lease)lease).getLeaseCounter()));
        UpdateRowRequest request = new UpdateRowRequest(change);
        return request;
    }

    Condition getCounterCheckCondition(long counter) {
        SingleColumnValueCondition counterCondition = new SingleColumnValueCondition(LEASE_COUNTER, SingleColumnValueCondition.CompareOperator.EQUAL, ColumnValue.fromLong((long)counter));
        counterCondition.setPassIfMissing(false);
        counterCondition.setLatestVersionsOnly(true);
        Condition condition = new Condition();
        condition.setColumnCondition((ColumnCondition)counterCondition);
        return condition;
    }

    abstract PutRowRequest getPutRowRequest(T var1);

    abstract UpdateRowRequest getUpdateRowRequestForUpdate(T var1);

    abstract T fromOTSRow(Row var1);
}

