/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.model;

import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.model.IRetryStrategy;
import com.aliyun.openservices.ots.internal.streamclient.utils.TimeUtils;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingCallableDecorator<T>
implements Callable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingCallableDecorator.class);
    private final IRetryStrategy.RetryableAction actionName;
    private final IRetryStrategy retryStrategy;
    private final Callable<T> callable;

    public RetryingCallableDecorator(IRetryStrategy.RetryableAction actionName, IRetryStrategy retryStrategy, Callable<T> callable) {
        this.actionName = actionName;
        this.retryStrategy = retryStrategy;
        this.callable = callable;
    }

    @Override
    public T call() throws DependencyException, StreamClientException {
        int retries = 0;
        while (true) {
            try {
                return this.callable.call();
            }
            catch (Exception ex) {
                if (this.retryStrategy.shouldRetry(this.actionName, ex, retries)) {
                    TimeUtils.sleepMillis(this.retryStrategy.getBackoffTimeMillis(this.actionName, ex, retries));
                    ++retries;
                    continue;
                }
                if (ex instanceof DependencyException) {
                    throw (DependencyException)ex;
                }
                throw new StreamClientException(ex.getMessage(), ex);
            }
            break;
        }
    }
}

