/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.InternalClient;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowColumnIteratorImpl;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetShardIteratorResponse;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordResponse;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.ListStreamResponse;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowIterator;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import com.alicloud.openservices.tablestore.model.UpdateTableResponse;
import com.alicloud.openservices.tablestore.model.WideColumnIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class SyncClient
implements SyncClientInterface {
    private InternalClient internalClient;

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName);
    }

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, String stsToken) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, null, null, stsToken);
    }

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, config);
    }

    public SyncClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken) {
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, config, null, stsToken);
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.internalClient.setExtraHeaders(extraHeaders);
    }

    public String getEndpoint() {
        return this.internalClient.getEndpoint();
    }

    public String getInstanceName() {
        return this.internalClient.getInstanceName();
    }

    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(createTableRequest);
        Future<CreateTableResponse> res = this.internalClient.createTable(createTableRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public ListTableResponse listTable() throws TableStoreException, ClientException {
        Future<ListTableResponse> res = this.internalClient.listTable(null);
        return this.waitForFuture(res);
    }

    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<DescribeTableResponse> res = this.internalClient.describeTable(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(deleteTableRequest);
        Future<DeleteTableResponse> res = this.internalClient.deleteTable(deleteTableRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<UpdateTableResponse> res = this.internalClient.updateTable(request, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetRowResponse getRow(GetRowRequest getRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getRowRequest);
        Future<GetRowResponse> res = this.internalClient.getRow(getRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public PutRowResponse putRow(PutRowRequest putRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(putRowRequest);
        Future<PutRowResponse> res = this.internalClient.putRow(putRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public UpdateRowResponse updateRow(UpdateRowRequest updateRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(updateRowRequest);
        Future<UpdateRowResponse> res = this.internalClient.updateRow(updateRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public DeleteRowResponse deleteRow(DeleteRowRequest deleteRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(deleteRowRequest);
        Future<DeleteRowResponse> res = this.internalClient.deleteRow(deleteRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public BatchGetRowResponse batchGetRow(BatchGetRowRequest batchGetRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(batchGetRowRequest);
        Future<BatchGetRowResponse> res = this.internalClient.batchGetRow(batchGetRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public BatchWriteRowResponse batchWriteRow(BatchWriteRowRequest batchWriteRowRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(batchWriteRowRequest);
        Future<BatchWriteRowResponse> res = this.internalClient.batchWriteRow(batchWriteRowRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetRangeResponse getRange(GetRangeRequest getRangeRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getRangeRequest);
        Future<GetRangeResponse> res = this.internalClient.getRange(getRangeRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public ComputeSplitsBySizeResponse computeSplitsBySize(ComputeSplitsBySizeRequest computeSplitsBySizeRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(computeSplitsBySizeRequest);
        Future<ComputeSplitsBySizeResponse> res = this.internalClient.computeSplitsBySize(computeSplitsBySizeRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public Iterator<Row> createRangeIterator(RangeIteratorParameter rangeIteratorParameter) throws TableStoreException, ClientException {
        return new RowIterator(this, rangeIteratorParameter);
    }

    @Override
    public WideColumnIterator createWideColumnIterator(GetRowRequest getRowRequest) throws TableStoreException, ClientException {
        GetRowColumnIteratorImpl getRowColumnIterator = new GetRowColumnIteratorImpl(this.internalClient, getRowRequest);
        if (getRowColumnIterator.isRowExistent()) {
            return new WideColumnIterator(getRowRequest.getRowQueryCriteria().getPrimaryKey(), getRowColumnIterator);
        }
        return null;
    }

    @Override
    public ListStreamResponse listStream(ListStreamRequest listStreamRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(listStreamRequest);
        Future<ListStreamResponse> res = this.internalClient.listStream(listStreamRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(describeStreamRequest);
        Future<DescribeStreamResponse> res = this.internalClient.describeStream(describeStreamRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getShardIteratorRequest);
        Future<GetShardIteratorResponse> res = this.internalClient.getShardIterator(getShardIteratorRequest, null);
        return this.waitForFuture(res);
    }

    @Override
    public GetStreamRecordResponse getStreamRecord(GetStreamRecordRequest getStreamRecordRequest) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(getStreamRecordRequest);
        Future<GetStreamRecordResponse> res = this.internalClient.getStreamRecord(getStreamRecordRequest, null);
        return this.waitForFuture(res);
    }

    private <Res> Res waitForFuture(Future<Res> f) {
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
    }

    @Override
    public void shutdown() {
        this.internalClient.shutdown();
    }
}

