/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCrc8;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import java.io.IOException;

public class PlainBufferCell {
    private String cellName;
    private byte[] nameRawData;
    private boolean hasCellName = false;
    private ColumnValue cellValue;
    private boolean hasCellValue = false;
    private boolean isPk = false;
    private PrimaryKeyValue pkCellValue;
    private byte cellType;
    private boolean hasCellType = false;
    private long cellTimestamp;
    private boolean hasCellTimestamp = false;
    private byte checksum;
    private boolean hasChecksum = false;

    public String getCellName() {
        return this.cellName;
    }

    public byte[] getNameRawData() {
        if (this.nameRawData == null) {
            this.nameRawData = Bytes.toBytes(this.cellName);
        }
        return this.nameRawData;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
        this.hasCellName = true;
        this.nameRawData = null;
        this.hasChecksum = false;
    }

    public boolean hasCellName() {
        return this.hasCellName;
    }

    public ColumnValue getCellValue() {
        return this.cellValue;
    }

    public void setCellValue(ColumnValue cellValue) {
        this.cellValue = cellValue;
        this.hasCellValue = true;
        this.hasChecksum = false;
    }

    public boolean hasCellValue() {
        return this.hasCellValue;
    }

    public byte getCellType() {
        return this.cellType;
    }

    public void setCellType(byte cellType) {
        this.cellType = cellType;
        this.hasCellType = true;
        this.hasChecksum = false;
    }

    public boolean hasCellType() {
        return this.hasCellType;
    }

    public long getCellTimestamp() {
        return this.cellTimestamp;
    }

    public void setCellTimestamp(long cellTimestamp) {
        this.cellTimestamp = cellTimestamp;
        this.hasCellTimestamp = true;
        this.hasChecksum = false;
    }

    public boolean hasCellTimestamp() {
        return this.hasCellTimestamp;
    }

    public byte getChecksum() throws IOException {
        if (!this.hasChecksum) {
            this.generateChecksum();
        }
        return this.checksum;
    }

    private void generateChecksum() throws IOException {
        this.checksum = PlainBufferCrc8.getChecksum((byte)0, this);
        this.hasChecksum = true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PlainBufferCell)) {
            return false;
        }
        try {
            if (this.getChecksum() != ((PlainBufferCell)o).getChecksum()) {
                return false;
            }
        }
        catch (IOException e) {
            throw new ClientException("Error when getChecksum.", e);
        }
        if (this.hasCellName() != ((PlainBufferCell)o).hasCellName() || this.hasCellName() && !this.getCellName().equals(((PlainBufferCell)o).getCellName())) {
            return false;
        }
        if (this.hasCellValue() != ((PlainBufferCell)o).hasCellValue() || this.hasCellValue() && !this.getCellValue().equals(((PlainBufferCell)o).getCellValue())) {
            return false;
        }
        if (this.isPk() != ((PlainBufferCell)o).isPk() || this.isPk() && !this.getPkCellValue().equals(((PlainBufferCell)o).getPkCellValue())) {
            return false;
        }
        if (this.hasCellType() != ((PlainBufferCell)o).hasCellType() || this.hasCellType() && this.getCellType() != ((PlainBufferCell)o).getCellType()) {
            return false;
        }
        return this.hasCellTimestamp() == ((PlainBufferCell)o).hasCellTimestamp() && (!this.hasCellTimestamp() || this.getCellTimestamp() == ((PlainBufferCell)o).getCellTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CellName: " + this.hasCellName() + "|" + this.cellName);
        sb.append(", CellValue: " + this.hasCellValue() + "|" + this.cellValue);
        sb.append(", CellType: " + this.hasCellType() + "|" + this.cellType);
        sb.append(", IsPk: " + this.isPk() + "|" + this.getPkCellValue());
        sb.append(", CellTimestamp: " + this.hasCellTimestamp() + "|" + this.cellTimestamp);
        sb.append(", Checksum: " + this.hasChecksum + "|" + this.checksum);
        return sb.toString();
    }

    public boolean isPk() {
        return this.isPk;
    }

    public PrimaryKeyValue getPkCellValue() {
        return this.pkCellValue;
    }

    public void setPkCellValue(PrimaryKeyValue pkCellValue) {
        this.pkCellValue = pkCellValue;
        this.hasCellValue = true;
        this.hasChecksum = false;
        this.isPk = true;
    }
}

