/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.utils;

public class OptionalValue<T> {
    private String name;
    private T value;
    private boolean isSet;

    public OptionalValue(String name) {
        this.name = name;
        this.value = null;
        this.isSet = false;
    }

    public void setValue(T value) {
        this.isSet = true;
        this.value = value;
    }

    public T getValue() {
        if (!this.isSet) {
            return null;
        }
        return this.value;
    }

    public boolean isValueSet() {
        return this.isSet;
    }

    public void clear() {
        this.value = null;
        this.isSet = false;
    }

    public int hashCode() {
        return this.isSet ? this.value.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OptionalValue)) {
            return false;
        }
        OptionalValue v1 = (OptionalValue)o;
        if (this.isSet) {
            return v1.isSet ? this.value.equals(v1.value) : false;
        }
        return !v1.isSet;
    }

    public String toString() {
        if (this.isSet) {
            return this.name + ":" + this.value;
        }
        return this.name + ":NotSet";
    }
}

