/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.writer.DefaultWriterStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlushCallback<Req, Res>
implements TableStoreCallback<Req, Res> {
    private Logger logger = LoggerFactory.getLogger(FlushCallback.class);
    private AsyncClientInterface ots;
    private AtomicInteger count;
    private Semaphore semaphore;
    private long startTime;
    private TableStoreCallback<RowChange, ConsumedCapacity> callback;
    private Executor executor;
    private DefaultWriterStatistics writerStatistics;

    public FlushCallback(AsyncClientInterface ots, AtomicInteger count, Semaphore semaphore, TableStoreCallback<RowChange, ConsumedCapacity> callback, Executor executor, DefaultWriterStatistics writerStatistics) {
        this.ots = ots;
        this.count = count;
        this.semaphore = semaphore;
        this.startTime = System.currentTimeMillis();
        this.callback = callback;
        this.executor = executor;
        this.writerStatistics = writerStatistics;
    }

    private void triggerSucceedCallback(final RowChange rowChange, final ConsumedCapacity consumedCapacity) {
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ((FlushCallback)FlushCallback.this).writerStatistics.totalSucceedRowsCount.incrementAndGet();
                FlushCallback.this.callback.onCompleted(rowChange, consumedCapacity);
            }
        });
    }

    private void triggerFailedCallback(final RowChange rowChange, final Exception exp) {
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ((FlushCallback)FlushCallback.this).writerStatistics.totalFailedRowsCount.incrementAndGet();
                FlushCallback.this.callback.onFailed(rowChange, exp);
            }
        });
    }

    private void triggerFailedCallback(final List<RowChange> rowChanges, final Exception exp) {
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (RowChange rowChange : rowChanges) {
                    ((FlushCallback)FlushCallback.this).writerStatistics.totalFailedRowsCount.incrementAndGet();
                    FlushCallback.this.callback.onFailed(rowChange, exp);
                }
            }
        });
    }

    private void requestComplete() {
        int remain = this.count.decrementAndGet();
        if (remain == 0) {
            this.semaphore.release();
            this.logger.debug("Release semaphore.");
        }
        long endTime = System.currentTimeMillis();
        this.logger.debug("BatchWriteRow latency: {}", (Object)(endTime - this.startTime));
    }

    @Override
    public void onCompleted(BatchWriteRowRequest originRequest, BatchWriteRowResponse result) {
        ArrayList<BatchWriteRowResponse.RowResult> succeed = new ArrayList<BatchWriteRowResponse.RowResult>();
        ArrayList<BatchWriteRowResponse.RowResult> failed = new ArrayList<BatchWriteRowResponse.RowResult>();
        result.getResult(succeed, failed);
        for (BatchWriteRowResponse.RowResult status : succeed) {
            this.triggerSucceedCallback(originRequest.getRowChange(status.getTableName(), status.getIndex()), status.getConsumedCapacity());
        }
        for (BatchWriteRowResponse.RowResult status : failed) {
            Error error = status.getError();
            this.triggerFailedCallback(originRequest.getRowChange(status.getTableName(), status.getIndex()), (Exception)new TableStoreException(error.getMessage(), null, error.getCode(), result.getRequestId(), 0));
        }
    }

    @Override
    public void onCompleted(Req request, Res response) {
        this.logger.debug("OnComplete: {}", (Object)request.getClass().getName());
        if (request instanceof BatchWriteRowRequest) {
            this.onCompleted((BatchWriteRowRequest)request, (BatchWriteRowResponse)response);
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            this.triggerSucceedCallback(pr.getRowChange(), ((PutRowResponse)response).getConsumedCapacity());
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            this.triggerSucceedCallback(ur.getRowChange(), ((UpdateRowResponse)response).getConsumedCapacity());
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            this.triggerSucceedCallback(dr.getRowChange(), ((DeleteRowResponse)response).getConsumedCapacity());
        }
        this.requestComplete();
    }

    @Override
    public void onFailed(Req request, Exception ex) {
        if (ex instanceof TableStoreException) {
            this.failedOnException(request, (TableStoreException)ex);
        } else {
            this.failedOnUnknownException(request, ex);
        }
    }

    public void failedOnException(Req request, TableStoreException ex) {
        this.logger.debug("OnFailed on TableStoreException: {}, {}", (Object)request.getClass().getName(), (Object)ex);
        if (request instanceof BatchWriteRowRequest) {
            this.retryBatchWrite((BatchWriteRowRequest)request);
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            this.triggerFailedCallback(pr.getRowChange(), (Exception)ex);
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            this.triggerFailedCallback(ur.getRowChange(), (Exception)ex);
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            this.triggerFailedCallback(dr.getRowChange(), (Exception)ex);
        }
        this.requestComplete();
    }

    public void failedOnUnknownException(Req request, Exception ex) {
        this.logger.debug("OnFailed on ClientException: {}, {}", (Object)request.getClass().getName(), (Object)ex);
        ArrayList<RowChange> failedRows = new ArrayList<RowChange>();
        if (request instanceof BatchWriteRowRequest) {
            BatchWriteRowRequest bwr = (BatchWriteRowRequest)request;
            for (Map.Entry<String, List<RowChange>> entry : bwr.getRowChange().entrySet()) {
                failedRows.addAll((Collection<RowChange>)entry.getValue());
            }
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            failedRows.add(pr.getRowChange());
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            failedRows.add(ur.getRowChange());
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            failedRows.add(dr.getRowChange());
        }
        this.triggerFailedCallback(failedRows, ex);
        this.requestComplete();
    }

    private void retryBatchWrite(BatchWriteRowRequest request) {
        for (Map.Entry<String, List<RowChange>> entry : request.getRowChange().entrySet()) {
            this.count.addAndGet(entry.getValue().size());
            for (RowChange rowChange : entry.getValue()) {
                if (rowChange instanceof RowPutChange) {
                    RowPutChange rowPutChange = (RowPutChange)rowChange;
                    PutRowRequest pr = new PutRowRequest();
                    pr.setRowChange(rowPutChange);
                    this.writerStatistics.totalSingleRowRequestCount.incrementAndGet();
                    this.writerStatistics.totalRequestCount.incrementAndGet();
                    this.ots.putRow(pr, new FlushCallback<PutRowRequest, PutRowResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.writerStatistics));
                    continue;
                }
                if (rowChange instanceof RowUpdateChange) {
                    UpdateRowRequest ur = new UpdateRowRequest();
                    RowUpdateChange rowUpdateChange = (RowUpdateChange)rowChange;
                    ur.setRowChange(rowUpdateChange);
                    this.writerStatistics.totalSingleRowRequestCount.incrementAndGet();
                    this.writerStatistics.totalRequestCount.incrementAndGet();
                    this.ots.updateRow(ur, new FlushCallback<UpdateRowRequest, UpdateRowResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.writerStatistics));
                    continue;
                }
                if (!(rowChange instanceof RowDeleteChange)) continue;
                DeleteRowRequest dr = new DeleteRowRequest();
                RowDeleteChange rowDeleteChange = (RowDeleteChange)rowChange;
                dr.setRowChange(rowDeleteChange);
                this.writerStatistics.totalSingleRowRequestCount.incrementAndGet();
                this.writerStatistics.totalRequestCount.incrementAndGet();
                this.ots.deleteRow(dr, new FlushCallback<DeleteRowRequest, DeleteRowResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.writerStatistics));
            }
        }
    }
}

