/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.InvalidCredentialsException;
import com.aliyun.oss.common.auth.STSAssumeRoleSessionCredentialsProvider;
import com.aliyuncs.auth.BasicCredentials;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssumedRoleCredentialProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AssumedRoleCredentialProvider.class);
    public static final String NAME = "org.apache.hadoop.fs.aliyun.oss.AssumedRoleCredentialProvider";
    private Credentials credentials;
    private String roleArn;
    private long duration;
    private String stsEndpoint;
    private String sessionName;
    private double expiredFactor;
    private STSAssumeRoleSessionCredentialsProvider stsCredentialsProvider;

    public AssumedRoleCredentialProvider(URI uri, Configuration conf) {
        String accessKeySecret;
        String accessKeyId;
        this.roleArn = conf.getTrimmed("fs.oss.assumed.role.arn", "");
        if (StringUtils.isEmpty((String)this.roleArn)) {
            throw new InvalidCredentialsException("fs.oss.assumed.role.arn is empty");
        }
        this.duration = conf.getLong("fs.oss.assumed.role.session.duration", 1800L);
        this.expiredFactor = conf.getDouble("fs.oss.assumed.role.sts.expiredFactor", 0.8);
        this.stsEndpoint = conf.getTrimmed("fs.oss.assumed.role.sts.endpoint", "");
        if (StringUtils.isEmpty((String)this.stsEndpoint)) {
            throw new InvalidCredentialsException("fs.oss.assumed.role.sts.endpoint is empty");
        }
        this.sessionName = conf.getTrimmed("fs.oss.assumed.role.session.name", "");
        try {
            accessKeyId = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeyId");
            accessKeySecret = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeySecret");
        }
        catch (IOException e) {
            throw new InvalidCredentialsException(e);
        }
        try {
            DefaultProfile.addEndpoint("", "", "Sts", this.stsEndpoint);
        }
        catch (ClientException e) {
            throw new InvalidCredentialsException(e);
        }
        this.stsCredentialsProvider = new STSAssumeRoleSessionCredentialsProvider(new BasicCredentials(accessKeyId, accessKeySecret), this.roleArn, (IClientProfile)DefaultProfile.getProfile("", accessKeyId, accessKeySecret)).withExpiredDuration(this.duration).withExpiredFactor(this.expiredFactor);
        if (!StringUtils.isEmpty((String)this.sessionName)) {
            this.stsCredentialsProvider.withRoleSessionName(this.sessionName);
        }
    }

    @Override
    public void setCredentials(Credentials creds) {
        throw new InvalidCredentialsException("Should not set credentials from external call");
    }

    @Override
    public Credentials getCredentials() {
        this.credentials = this.stsCredentialsProvider.getCredentials();
        if (this.credentials == null) {
            throw new InvalidCredentialsException("Invalid credentials");
        }
        return this.credentials;
    }
}

