/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.AutoScalingGroupConfiguration;
import com.amazonaws.services.computeoptimizer.model.AutoScalingGroupRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.CurrentPerformanceRisk;
import com.amazonaws.services.computeoptimizer.model.EffectiveRecommendationPreferences;
import com.amazonaws.services.computeoptimizer.model.Finding;
import com.amazonaws.services.computeoptimizer.model.InferredWorkloadType;
import com.amazonaws.services.computeoptimizer.model.UtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.transform.AutoScalingGroupRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AutoScalingGroupRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String autoScalingGroupArn;
    private String autoScalingGroupName;
    private String finding;
    private List<UtilizationMetric> utilizationMetrics;
    private Double lookBackPeriodInDays;
    private AutoScalingGroupConfiguration currentConfiguration;
    private List<AutoScalingGroupRecommendationOption> recommendationOptions;
    private Date lastRefreshTimestamp;
    private String currentPerformanceRisk;
    private EffectiveRecommendationPreferences effectiveRecommendationPreferences;
    private List<String> inferredWorkloadTypes;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public AutoScalingGroupRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setAutoScalingGroupArn(String autoScalingGroupArn) {
        this.autoScalingGroupArn = autoScalingGroupArn;
    }

    public String getAutoScalingGroupArn() {
        return this.autoScalingGroupArn;
    }

    public AutoScalingGroupRecommendation withAutoScalingGroupArn(String autoScalingGroupArn) {
        this.setAutoScalingGroupArn(autoScalingGroupArn);
        return this;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public AutoScalingGroupRecommendation withAutoScalingGroupName(String autoScalingGroupName) {
        this.setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    public void setFinding(String finding) {
        this.finding = finding;
    }

    public String getFinding() {
        return this.finding;
    }

    public AutoScalingGroupRecommendation withFinding(String finding) {
        this.setFinding(finding);
        return this;
    }

    public AutoScalingGroupRecommendation withFinding(Finding finding) {
        this.finding = finding.toString();
        return this;
    }

    public List<UtilizationMetric> getUtilizationMetrics() {
        return this.utilizationMetrics;
    }

    public void setUtilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
        if (utilizationMetrics == null) {
            this.utilizationMetrics = null;
            return;
        }
        this.utilizationMetrics = new ArrayList<UtilizationMetric>(utilizationMetrics);
    }

    public AutoScalingGroupRecommendation withUtilizationMetrics(UtilizationMetric ... utilizationMetrics) {
        if (this.utilizationMetrics == null) {
            this.setUtilizationMetrics(new ArrayList<UtilizationMetric>(utilizationMetrics.length));
        }
        for (UtilizationMetric ele : utilizationMetrics) {
            this.utilizationMetrics.add(ele);
        }
        return this;
    }

    public AutoScalingGroupRecommendation withUtilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
        this.setUtilizationMetrics(utilizationMetrics);
        return this;
    }

    public void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
        this.lookBackPeriodInDays = lookBackPeriodInDays;
    }

    public Double getLookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public AutoScalingGroupRecommendation withLookBackPeriodInDays(Double lookBackPeriodInDays) {
        this.setLookBackPeriodInDays(lookBackPeriodInDays);
        return this;
    }

    public void setCurrentConfiguration(AutoScalingGroupConfiguration currentConfiguration) {
        this.currentConfiguration = currentConfiguration;
    }

    public AutoScalingGroupConfiguration getCurrentConfiguration() {
        return this.currentConfiguration;
    }

    public AutoScalingGroupRecommendation withCurrentConfiguration(AutoScalingGroupConfiguration currentConfiguration) {
        this.setCurrentConfiguration(currentConfiguration);
        return this;
    }

    public List<AutoScalingGroupRecommendationOption> getRecommendationOptions() {
        return this.recommendationOptions;
    }

    public void setRecommendationOptions(Collection<AutoScalingGroupRecommendationOption> recommendationOptions) {
        if (recommendationOptions == null) {
            this.recommendationOptions = null;
            return;
        }
        this.recommendationOptions = new ArrayList<AutoScalingGroupRecommendationOption>(recommendationOptions);
    }

    public AutoScalingGroupRecommendation withRecommendationOptions(AutoScalingGroupRecommendationOption ... recommendationOptions) {
        if (this.recommendationOptions == null) {
            this.setRecommendationOptions(new ArrayList<AutoScalingGroupRecommendationOption>(recommendationOptions.length));
        }
        for (AutoScalingGroupRecommendationOption ele : recommendationOptions) {
            this.recommendationOptions.add(ele);
        }
        return this;
    }

    public AutoScalingGroupRecommendation withRecommendationOptions(Collection<AutoScalingGroupRecommendationOption> recommendationOptions) {
        this.setRecommendationOptions(recommendationOptions);
        return this;
    }

    public void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public AutoScalingGroupRecommendation withLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    public void setCurrentPerformanceRisk(String currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk;
    }

    public String getCurrentPerformanceRisk() {
        return this.currentPerformanceRisk;
    }

    public AutoScalingGroupRecommendation withCurrentPerformanceRisk(String currentPerformanceRisk) {
        this.setCurrentPerformanceRisk(currentPerformanceRisk);
        return this;
    }

    public AutoScalingGroupRecommendation withCurrentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk.toString();
        return this;
    }

    public void setEffectiveRecommendationPreferences(EffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
    }

    public EffectiveRecommendationPreferences getEffectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    public AutoScalingGroupRecommendation withEffectiveRecommendationPreferences(EffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        this.setEffectiveRecommendationPreferences(effectiveRecommendationPreferences);
        return this;
    }

    public List<String> getInferredWorkloadTypes() {
        return this.inferredWorkloadTypes;
    }

    public void setInferredWorkloadTypes(Collection<String> inferredWorkloadTypes) {
        if (inferredWorkloadTypes == null) {
            this.inferredWorkloadTypes = null;
            return;
        }
        this.inferredWorkloadTypes = new ArrayList<String>(inferredWorkloadTypes);
    }

    public AutoScalingGroupRecommendation withInferredWorkloadTypes(String ... inferredWorkloadTypes) {
        if (this.inferredWorkloadTypes == null) {
            this.setInferredWorkloadTypes(new ArrayList<String>(inferredWorkloadTypes.length));
        }
        for (String ele : inferredWorkloadTypes) {
            this.inferredWorkloadTypes.add(ele);
        }
        return this;
    }

    public AutoScalingGroupRecommendation withInferredWorkloadTypes(Collection<String> inferredWorkloadTypes) {
        this.setInferredWorkloadTypes(inferredWorkloadTypes);
        return this;
    }

    public AutoScalingGroupRecommendation withInferredWorkloadTypes(InferredWorkloadType ... inferredWorkloadTypes) {
        ArrayList<String> inferredWorkloadTypesCopy = new ArrayList<String>(inferredWorkloadTypes.length);
        for (InferredWorkloadType value : inferredWorkloadTypes) {
            inferredWorkloadTypesCopy.add(value.toString());
        }
        if (this.getInferredWorkloadTypes() == null) {
            this.setInferredWorkloadTypes(inferredWorkloadTypesCopy);
        } else {
            this.getInferredWorkloadTypes().addAll(inferredWorkloadTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getAutoScalingGroupArn() != null) {
            sb.append("AutoScalingGroupArn: ").append(this.getAutoScalingGroupArn()).append(",");
        }
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.getAutoScalingGroupName()).append(",");
        }
        if (this.getFinding() != null) {
            sb.append("Finding: ").append(this.getFinding()).append(",");
        }
        if (this.getUtilizationMetrics() != null) {
            sb.append("UtilizationMetrics: ").append(this.getUtilizationMetrics()).append(",");
        }
        if (this.getLookBackPeriodInDays() != null) {
            sb.append("LookBackPeriodInDays: ").append(this.getLookBackPeriodInDays()).append(",");
        }
        if (this.getCurrentConfiguration() != null) {
            sb.append("CurrentConfiguration: ").append(this.getCurrentConfiguration()).append(",");
        }
        if (this.getRecommendationOptions() != null) {
            sb.append("RecommendationOptions: ").append(this.getRecommendationOptions()).append(",");
        }
        if (this.getLastRefreshTimestamp() != null) {
            sb.append("LastRefreshTimestamp: ").append(this.getLastRefreshTimestamp()).append(",");
        }
        if (this.getCurrentPerformanceRisk() != null) {
            sb.append("CurrentPerformanceRisk: ").append(this.getCurrentPerformanceRisk()).append(",");
        }
        if (this.getEffectiveRecommendationPreferences() != null) {
            sb.append("EffectiveRecommendationPreferences: ").append(this.getEffectiveRecommendationPreferences()).append(",");
        }
        if (this.getInferredWorkloadTypes() != null) {
            sb.append("InferredWorkloadTypes: ").append(this.getInferredWorkloadTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupRecommendation)) {
            return false;
        }
        AutoScalingGroupRecommendation other = (AutoScalingGroupRecommendation)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getAutoScalingGroupArn() == null ^ this.getAutoScalingGroupArn() == null) {
            return false;
        }
        if (other.getAutoScalingGroupArn() != null && !other.getAutoScalingGroupArn().equals(this.getAutoScalingGroupArn())) {
            return false;
        }
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getFinding() == null ^ this.getFinding() == null) {
            return false;
        }
        if (other.getFinding() != null && !other.getFinding().equals(this.getFinding())) {
            return false;
        }
        if (other.getUtilizationMetrics() == null ^ this.getUtilizationMetrics() == null) {
            return false;
        }
        if (other.getUtilizationMetrics() != null && !other.getUtilizationMetrics().equals(this.getUtilizationMetrics())) {
            return false;
        }
        if (other.getLookBackPeriodInDays() == null ^ this.getLookBackPeriodInDays() == null) {
            return false;
        }
        if (other.getLookBackPeriodInDays() != null && !other.getLookBackPeriodInDays().equals(this.getLookBackPeriodInDays())) {
            return false;
        }
        if (other.getCurrentConfiguration() == null ^ this.getCurrentConfiguration() == null) {
            return false;
        }
        if (other.getCurrentConfiguration() != null && !other.getCurrentConfiguration().equals(this.getCurrentConfiguration())) {
            return false;
        }
        if (other.getRecommendationOptions() == null ^ this.getRecommendationOptions() == null) {
            return false;
        }
        if (other.getRecommendationOptions() != null && !other.getRecommendationOptions().equals(this.getRecommendationOptions())) {
            return false;
        }
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null) {
            return false;
        }
        if (other.getLastRefreshTimestamp() != null && !other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp())) {
            return false;
        }
        if (other.getCurrentPerformanceRisk() == null ^ this.getCurrentPerformanceRisk() == null) {
            return false;
        }
        if (other.getCurrentPerformanceRisk() != null && !other.getCurrentPerformanceRisk().equals(this.getCurrentPerformanceRisk())) {
            return false;
        }
        if (other.getEffectiveRecommendationPreferences() == null ^ this.getEffectiveRecommendationPreferences() == null) {
            return false;
        }
        if (other.getEffectiveRecommendationPreferences() != null && !other.getEffectiveRecommendationPreferences().equals(this.getEffectiveRecommendationPreferences())) {
            return false;
        }
        if (other.getInferredWorkloadTypes() == null ^ this.getInferredWorkloadTypes() == null) {
            return false;
        }
        return other.getInferredWorkloadTypes() == null || other.getInferredWorkloadTypes().equals(this.getInferredWorkloadTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupArn() == null ? 0 : this.getAutoScalingGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getFinding() == null ? 0 : this.getFinding().hashCode());
        hashCode = 31 * hashCode + (this.getUtilizationMetrics() == null ? 0 : this.getUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getLookBackPeriodInDays() == null ? 0 : this.getLookBackPeriodInDays().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentConfiguration() == null ? 0 : this.getCurrentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationOptions() == null ? 0 : this.getRecommendationOptions().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTimestamp() == null ? 0 : this.getLastRefreshTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPerformanceRisk() == null ? 0 : this.getCurrentPerformanceRisk().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveRecommendationPreferences() == null ? 0 : this.getEffectiveRecommendationPreferences().hashCode());
        hashCode = 31 * hashCode + (this.getInferredWorkloadTypes() == null ? 0 : this.getInferredWorkloadTypes().hashCode());
        return hashCode;
    }

    public AutoScalingGroupRecommendation clone() {
        try {
            return (AutoScalingGroupRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingGroupRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

