/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cert;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.cert.model.CertCreateRequest;
import com.baidubce.services.cert.model.CertCreateResponse;
import com.baidubce.services.cert.model.CertListRequest;
import com.baidubce.services.cert.model.CertListResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class CertClient
extends AbstractBceClient {
    private static final String CERT_BASE_URL = "/certificate";
    private static final String VERSION = "/v1";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date", "x-bce-console-rpc-id"};
    private static final HttpResponseHandler[] handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};
    private boolean internal;
    private String accessKey;
    private String secretKey;

    protected CertClient(String accessKey, String secretKey, BceClientConfiguration bceClientConfiguration, boolean internal) {
        super(bceClientConfiguration, handlers);
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.internal = internal;
    }

    public static CertClient createCertClient(String accessKey, String secretKey, String endpoint) {
        BceClientConfiguration bceClientConfiguration = new BceClientConfiguration().withEndpoint(endpoint).withCredentials(new DefaultBceCredentials(accessKey, secretKey));
        return new CertClient(accessKey, secretKey, bceClientConfiguration, false);
    }

    public CertCreateResponse createCert(CertCreateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CERT_BASE_URL);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CertCreateResponse.class);
    }

    public CertListResponse listUserCerts() {
        CertListRequest request = new CertListRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CERT_BASE_URL);
        return this.invokeHttpClient(internalRequest, CertListResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void attachRequestToBody(AbstractBceRequest request, InternalRequest httpRequest) {
        byte[] content;
        try {
            content = JsonUtils.toJsonString(request).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("utf-8 encoding not supported!", e);
        }
        httpRequest.addHeader("Content-Length", String.valueOf(content.length));
        httpRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setContent(RestartableInputStream.wrap(content));
    }
}

