/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotsmarthome;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotsmarthome.model.CreateOtaJobRequest;
import com.baidubce.services.iotsmarthome.model.CreateOtaJobResponse;
import com.baidubce.services.iotsmarthome.model.DeviceActivationRequest;
import com.baidubce.services.iotsmarthome.model.DeviceProfileUpdateRequest;
import com.baidubce.services.iotsmarthome.model.DeviceSecurityInfo;
import com.baidubce.services.iotsmarthome.model.DeviceStatus;
import com.baidubce.services.iotsmarthome.model.StatusResponse;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

public class IotSmarthomeClient
extends AbstractBceClient {
    private static final String ENDPOINT = "smarthome.gz.baidubce.com";
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String VERSION = "v1";
    private static final String DEVICE = "device";
    private static final String PRODUCT = "product";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host", "x-bce-date"};
    private static final HttpResponseHandler[] HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public IotSmarthomeClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, HANDLERS);
    }

    public IotSmarthomeClient(String accessKey, String secretKey) {
        this(new BceClientConfiguration().withCredentials(new DefaultBceCredentials(accessKey, secretKey)).withEndpoint(ENDPOINT));
    }

    public void preActivateDevice(String puid, DeviceActivationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE, puid, "active");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deActivateDevice(String puid, DeviceActivationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICE, puid, "deactive");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceStatus getDeviceStatus(String puid) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, puid, "status");
        return this.invokeHttpClient(internalRequest, DeviceStatus.class);
    }

    public StatusResponse getDeviceActivationStatus(String puid) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, puid, "status/activation");
        return this.invokeHttpClient(internalRequest, StatusResponse.class);
    }

    public StatusResponse getDeviceConnectionStatus(String puid) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, puid, "status/connect");
        return this.invokeHttpClient(internalRequest, StatusResponse.class);
    }

    public DeviceSecurityInfo getSecurityInfo(String puid) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, puid, "security");
        return this.invokeHttpClient(internalRequest, DeviceSecurityInfo.class);
    }

    public void updateDeviceProfile(String puid, DeviceProfileUpdateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICE, puid, "profile");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateOtaJobResponse createOtaJob(String uuid, CreateOtaJobRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCT, uuid, "ota/job");
        return this.invokeHttpClient(internalRequest, CreateOtaJobResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.addHeader("x-bce-date", DateUtils.formatAlternateIso8601Date(new Date()));
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeadAndBody(bceRequest, request);
        }
        return request;
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

