/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.tsdb.AbstractTsdbBceClient;
import com.baidubce.services.tsdb.model.CreateDatabaseRequest;
import com.baidubce.services.tsdb.model.CreateDatabaseResponse;
import com.baidubce.services.tsdb.model.DeleteDatabaseRequest;
import com.baidubce.services.tsdb.model.DeleteDatabaseResponse;
import com.baidubce.services.tsdb.model.DeleteDatapointsRequest;
import com.baidubce.services.tsdb.model.DeleteDatapointsResponse;
import com.baidubce.services.tsdb.model.GetDatabaseRequest;
import com.baidubce.services.tsdb.model.GetDatabaseResponse;
import com.baidubce.services.tsdb.model.GetTaskRequest;
import com.baidubce.services.tsdb.model.GetTaskResponse;
import com.baidubce.services.tsdb.model.ListDatabaseRequest;
import com.baidubce.services.tsdb.model.ListDatabaseResponse;
import com.google.common.base.Preconditions;

public class TsdbAdminClient
extends AbstractTsdbBceClient {
    private static final String ENDPOINT_HOST = "tsdb.iot.gz.baidubce.com";
    private static final String DATABASE = "database";
    private static final String TASK = "task";
    private static final String CLIENT_TOKEN = "clientToken";

    public TsdbAdminClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT_HOST) : config, TSDB_HANDLERS);
    }

    public CreateDatabaseResponse createDatabase(CreateDatabaseRequest createDatabaseRequest, String clientToken) {
        Preconditions.checkNotNull((Object)createDatabaseRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(createDatabaseRequest, HttpMethodName.POST, DATABASE);
        internalRequest.addParameter(CLIENT_TOKEN, clientToken);
        this.fillInHeadAndBody(createDatabaseRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateDatabaseResponse.class);
    }

    public DeleteDatabaseResponse deleteDatabase(String databaseId) {
        Preconditions.checkNotNull((Object)databaseId, (Object)"database id should not be null.");
        return this.deleteDatabase(new DeleteDatabaseRequest().withDatabaseId(databaseId));
    }

    public DeleteDatabaseResponse deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) {
        Preconditions.checkNotNull((Object)deleteDatabaseRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(deleteDatabaseRequest, HttpMethodName.DELETE, DATABASE, deleteDatabaseRequest.getDatabaseId());
        return this.invokeHttpClient(internalRequest, DeleteDatabaseResponse.class);
    }

    public GetDatabaseResponse getDatabase(String databaseId) {
        Preconditions.checkNotNull((Object)databaseId, (Object)"database id should not be null.");
        return this.getDatabase(new GetDatabaseRequest().withDatabaseId(databaseId));
    }

    public GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) {
        Preconditions.checkNotNull((Object)getDatabaseRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(getDatabaseRequest, HttpMethodName.GET, DATABASE, getDatabaseRequest.getDatabaseId());
        return this.invokeHttpClient(internalRequest, GetDatabaseResponse.class);
    }

    public ListDatabaseResponse listDatabase() {
        return this.listDatabase(new ListDatabaseRequest());
    }

    public ListDatabaseResponse listDatabase(ListDatabaseRequest listDatabaseRequest) {
        Preconditions.checkNotNull((Object)listDatabaseRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listDatabaseRequest, HttpMethodName.GET, DATABASE);
        return this.invokeHttpClient(internalRequest, ListDatabaseResponse.class);
    }

    public DeleteDatapointsResponse deleteDatapoints(DeleteDatapointsRequest deleteDatapointsRequest) {
        Preconditions.checkNotNull((Object)deleteDatapointsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(deleteDatapointsRequest, HttpMethodName.PUT, DATABASE, deleteDatapointsRequest.getDatabaseId());
        internalRequest.addParameter("delete", null);
        this.fillInHeadAndBody(deleteDatapointsRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, DeleteDatapointsResponse.class);
    }

    public GetTaskResponse getTask(GetTaskRequest getTaskRequest) {
        Preconditions.checkNotNull((Object)getTaskRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(getTaskRequest, HttpMethodName.GET, DATABASE, getTaskRequest.getDatabaseId(), TASK, getTaskRequest.getTaskId());
        return this.invokeHttpClient(internalRequest, GetTaskResponse.class);
    }
}

