/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import java.util.Objects;

public abstract class Wrapper<T>
implements ISqlSegment {
    public abstract T getEntity();

    public String getSqlSelect() {
        return null;
    }

    public String getSqlSet() {
        return null;
    }

    public abstract MergeSegments getExpression();

    public boolean isEmptyOfWhere() {
        return this.isEmptyOfNormal() && this.isEmptyOfEntity();
    }

    public boolean nonEmptyOfWhere() {
        return !this.isEmptyOfWhere();
    }

    public boolean isEmptyOfNormal() {
        return CollectionUtils.isEmpty(this.getExpression().getNormal());
    }

    public boolean nonEmptyOfNormal() {
        return !this.isEmptyOfNormal();
    }

    public boolean nonEmptyOfEntity() {
        T entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
        if (tableInfo == null) {
            return false;
        }
        if (tableInfo.getFieldList().stream().anyMatch(e -> this.fieldStrategyMatch(entity, (TableFieldInfo)e))) {
            return true;
        }
        return StringUtils.isNotEmpty(tableInfo.getKeyProperty()) ? Objects.nonNull(ReflectionKit.getMethodValue(entity, tableInfo.getKeyProperty())) : false;
    }

    private boolean fieldStrategyMatch(T entity, TableFieldInfo e) {
        switch (e.getFieldStrategy()) {
            case NOT_NULL: {
                return Objects.nonNull(ReflectionKit.getMethodValue(entity, e.getProperty()));
            }
            case IGNORED: {
                return true;
            }
            case NOT_EMPTY: {
                return StringUtils.checkValNotNull(ReflectionKit.getMethodValue(entity, e.getProperty()));
            }
        }
        return Objects.nonNull(ReflectionKit.getMethodValue(entity, e.getProperty()));
    }

    public boolean isEmptyOfEntity() {
        return !this.nonEmptyOfEntity();
    }
}

