/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import com.blade.Environment;
import com.blade.event.BeanProcessor;
import com.blade.event.Event;
import com.blade.event.EventListener;
import com.blade.event.EventManager;
import com.blade.event.EventType;
import com.blade.exception.BladeException;
import com.blade.ioc.Ioc;
import com.blade.ioc.SimpleIoc;
import com.blade.kit.Assert;
import com.blade.kit.BladeKit;
import com.blade.kit.StringKit;
import com.blade.kit.reload.FileChangeDetector;
import com.blade.loader.BladeLoader;
import com.blade.mvc.Const;
import com.blade.mvc.handler.DefaultExceptionHandler;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.handler.RouteHandler0;
import com.blade.mvc.handler.WebSocketHandler;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.http.HttpSession;
import com.blade.mvc.http.Session;
import com.blade.mvc.http.session.SessionManager;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.template.DefaultEngine;
import com.blade.mvc.ui.template.TemplateEngine;
import com.blade.security.web.cors.CorsMiddleware;
import com.blade.server.Server;
import com.blade.server.netty.NettyServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blade {
    private static final Logger log = LoggerFactory.getLogger(Blade.class);
    private List<WebHook> middleware = new ArrayList<WebHook>();
    private List<BeanProcessor> processors = new ArrayList<BeanProcessor>();
    private List<BladeLoader> loaders = new ArrayList<BladeLoader>();
    private Set<String> packages = new LinkedHashSet<String>(Const.PLUGIN_PACKAGE_NAME);
    private Set<String> statics = new HashSet<String>(Const.DEFAULT_STATICS);
    private Ioc ioc = new SimpleIoc();
    private TemplateEngine templateEngine = new DefaultEngine();
    private EventManager eventManager = new EventManager();
    private SessionManager sessionManager = new SessionManager(this.eventManager);
    private CountDownLatch latch = new CountDownLatch(1);
    private Server server = new NettyServer();
    private RouteMatcher routeMatcher = new RouteMatcher();
    private Environment environment = Environment.empty();
    private Consumer<Exception> startupExceptionHandler = e -> log.error("Start blade failed", (Throwable)e);
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private boolean started = false;
    private Class<?> bootClass = null;
    private Class<? extends Session> sessionImplType = HttpSession.class;
    private String webSocketPath;
    private String bannerText;
    private String threadName;
    private WebSocketHandler webSocketHandler;

    @Deprecated
    public static Blade me() {
        return Blade.of();
    }

    public static Blade of() {
        return new Blade();
    }

    public Ioc ioc() {
        return this.ioc;
    }

    @Deprecated
    public Blade get(@NonNull String path, @NonNull RouteHandler0 handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.GET);
        return this;
    }

    public Blade get(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.GET);
        return this;
    }

    @Deprecated
    public Blade post(@NonNull String path, @NonNull RouteHandler0 handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.POST);
        return this;
    }

    public Blade post(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.POST);
        return this;
    }

    @Deprecated
    public Blade put(@NonNull String path, @NonNull RouteHandler0 handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.PUT);
        return this;
    }

    public Blade put(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.PUT);
        return this;
    }

    @Deprecated
    public Blade delete(@NonNull String path, @NonNull RouteHandler0 handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.DELETE);
        return this;
    }

    public Blade delete(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.DELETE);
        return this;
    }

    @Deprecated
    public Blade before(@NonNull String path, @NonNull RouteHandler0 handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.BEFORE);
        return this;
    }

    public Blade before(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.BEFORE);
        return this;
    }

    @Deprecated
    public Blade after(@NonNull String path, @NonNull RouteHandler0 handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.AFTER);
        return this;
    }

    public Blade after(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.AFTER);
        return this;
    }

    public Blade templateEngine(@NonNull TemplateEngine templateEngine) {
        if (templateEngine == null) {
            throw new NullPointerException("templateEngine");
        }
        this.templateEngine = templateEngine;
        return this;
    }

    public TemplateEngine templateEngine() {
        return this.templateEngine;
    }

    public RouteMatcher routeMatcher() {
        return this.routeMatcher;
    }

    public Blade register(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.ioc.addBean(bean);
        return this;
    }

    public Blade register(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        this.ioc.addBean(cls);
        return this;
    }

    public Blade addStatics(String ... folders) {
        if (folders == null) {
            throw new NullPointerException("folders");
        }
        this.statics.addAll(Arrays.asList(folders));
        return this;
    }

    public Blade showFileList(boolean fileList) {
        this.environment.set("mvc.statics.show-list", fileList);
        return this;
    }

    public Blade gzip(boolean gzipEnable) {
        this.environment.set("http.gzip.enable", gzipEnable);
        return this;
    }

    public <T> T getBean(@NonNull Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        return this.ioc.getBean(cls);
    }

    public ExceptionHandler exceptionHandler() {
        return this.exceptionHandler;
    }

    public Blade exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public boolean devMode() {
        return this.environment.getBoolean("app.devMode", true);
    }

    public Blade devMode(boolean devMode) {
        this.environment.set("app.devMode", devMode);
        return this;
    }

    public boolean isAutoRefreshDir() {
        return this.environment.get("app.auto.refresh.dir").isPresent();
    }

    public void setAutoRefreshDir(String dir) {
        this.environment.set("app.auto.refresh.dir", dir);
    }

    public Class<?> bootClass() {
        return this.bootClass;
    }

    public Blade enableCors(boolean enableCors) {
        this.environment.set("http.cors.enable", enableCors);
        if (enableCors) {
            this.use(new CorsMiddleware());
        }
        return this;
    }

    public Set<String> getStatics() {
        return this.statics;
    }

    public Blade scanPackages(String ... packages) {
        if (packages == null) {
            throw new NullPointerException("packages");
        }
        this.packages.addAll(Arrays.asList(packages));
        return this;
    }

    public Set<String> scanPackages() {
        return this.packages;
    }

    public Blade bootConf(@NonNull String bootConf) {
        if (bootConf == null) {
            throw new NullPointerException("bootConf");
        }
        this.environment.set("boot_conf", bootConf);
        return this;
    }

    @Deprecated
    public Blade environment(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.environment.set(key, value);
        return this;
    }

    public Environment environment() {
        return this.environment;
    }

    @Deprecated
    public Blade environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public Optional<String> env(String key) {
        return this.environment.get(key);
    }

    public String env(String key, String defaultValue) {
        return this.environment.get(key, defaultValue);
    }

    public Blade listen(int port) {
        Assert.greaterThan(port, 0.0, "server port not is negative number.");
        this.environment.set("server.port", port);
        return this;
    }

    public Blade listen(@NonNull String address, int port) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        Assert.greaterThan(port, 0.0, "server port not is negative number.");
        this.environment.set("server.address", address);
        this.environment.set("server.port", port);
        return this;
    }

    public Blade use(WebHook ... middleware) {
        if (middleware == null) {
            throw new NullPointerException("middleware");
        }
        if (BladeKit.isEmpty(middleware)) {
            return this;
        }
        this.middleware.addAll(Arrays.asList(middleware));
        for (WebHook webHook : middleware) {
            this.register(webHook);
        }
        return this;
    }

    public List<WebHook> middleware() {
        return this.middleware;
    }

    public Blade appName(@NonNull String appName) {
        if (appName == null) {
            throw new NullPointerException("appName");
        }
        this.environment.set("app.name", appName);
        return this;
    }

    public Blade event(@NonNull EventType eventType, @NonNull EventListener eventListener) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        if (eventListener == null) {
            throw new NullPointerException("eventListener");
        }
        this.eventManager.addEventListener(eventType, eventListener);
        return this;
    }

    public Blade on(@NonNull EventType eventType, @NonNull EventListener eventListener) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        if (eventListener == null) {
            throw new NullPointerException("eventListener");
        }
        this.eventManager.addEventListener(eventType, eventListener);
        return this;
    }

    public Class<? extends Session> sessionType() {
        return this.sessionImplType;
    }

    public Blade sessionType(Class<? extends Session> sessionImplType) {
        this.sessionImplType = sessionImplType;
        return this;
    }

    @Deprecated
    public Blade onStarted(@NonNull BeanProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        this.processors.add(processor);
        return this;
    }

    public Blade addLoader(@NonNull BladeLoader loader) {
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        this.loaders.add(loader);
        return this;
    }

    @Deprecated
    public List<BeanProcessor> processors() {
        return this.processors;
    }

    public List<BladeLoader> loaders() {
        return this.loaders;
    }

    public EventManager eventManager() {
        return this.eventManager;
    }

    public SessionManager sessionManager() {
        return this.sessionManager;
    }

    public Blade disableSession() {
        this.sessionManager = null;
        return this;
    }

    public Blade disableCost() {
        this.environment.set("http.request.cost", false);
        return this;
    }

    public boolean allowCost() {
        return this.environment.getBoolean("http.request.cost", true);
    }

    public Blade watchEnvChange(boolean watchEnvChange) {
        this.environment.set("app.watch-env", watchEnvChange);
        return this;
    }

    public Blade start() {
        return this.start(null, null);
    }

    public Blade start(Class<?> mainCls, String ... args) {
        return this.start(mainCls, "0.0.0.0", 9000, args);
    }

    public Blade start(Class<?> bootClass, @NonNull String address, int port, String ... args) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        try {
            this.loadConfig(args);
            this.environment.set("server.address", address);
            Assert.greaterThan(port, 0.0, "server port not is negative number.");
            this.bootClass = bootClass;
            this.eventManager.fireEvent(EventType.SERVER_STARTING, new Event().attribute("blade", this));
            Thread thread = new Thread(() -> {
                try {
                    this.server.start(this, args);
                    this.latch.countDown();
                    this.server.join();
                }
                catch (Exception e) {
                    this.startupExceptionHandler.accept(e);
                }
            });
            String threadName = null != this.threadName ? this.threadName : this.environment.get("app.thread-name", null);
            threadName = null != threadName ? threadName : "_(:3\u300d\u2220)_";
            thread.setName(threadName);
            thread.start();
            this.started = true;
            Thread resourceFilesRefreshThread = new Thread(() -> {
                try {
                    FileChangeDetector fileChangeDetector = new FileChangeDetector(this.environment.get("app.auto.refresh.dir").get());
                    fileChangeDetector.processEvent((event, filePath) -> {
                        try {
                            if (event.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                                Path destPath = FileChangeDetector.getDestPath(filePath, this.environment);
                                Files.copy(filePath, destPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (IOException e) {
                            log.error("Exception when trying to copy updated file");
                            this.startupExceptionHandler.accept(e);
                        }
                    });
                }
                catch (IOException e) {
                    this.startupExceptionHandler.accept(e);
                }
            });
            if (this.devMode() && this.isAutoRefreshDir()) {
                log.info("auto refresh is enabled");
                resourceFilesRefreshThread.start();
            }
        }
        catch (Exception e) {
            this.startupExceptionHandler.accept(e);
        }
        return this;
    }

    public Blade await() {
        if (!this.started) {
            throw new IllegalStateException("Server hasn't been started. Call start() before calling this method.");
        }
        try {
            this.latch.await();
        }
        catch (Exception e) {
            log.error("Blade start await error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public void stop() {
        this.eventManager.fireEvent(EventType.SERVER_STOPPING, new Event().attribute("blade", this));
        this.server.stopAndWait();
        this.eventManager.fireEvent(EventType.SERVER_STOPPED, new Event().attribute("blade", this));
    }

    public Blade webSocket(@NonNull String path, @NonNull WebSocketHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (null != this.webSocketHandler) {
            throw new BladeException(500, "There is already a WebSocket path.");
        }
        this.webSocketPath = path;
        this.webSocketHandler = handler;
        this.routeMatcher.addWebSocket(path);
        return this;
    }

    public String webSocketPath() {
        return this.webSocketPath;
    }

    public Blade bannerText(String bannerText) {
        this.bannerText = bannerText;
        return this;
    }

    public String bannerText() {
        if (null != this.bannerText) {
            return this.bannerText;
        }
        String bannerPath = this.environment.get("app.banner-path", null);
        if (StringKit.isEmpty(bannerPath) || Files.notExists(Paths.get(bannerPath, new String[0]), new LinkOption[0])) {
            return null;
        }
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(bannerPath, new String[0]));
            this.bannerText = bufferedReader.lines().collect(Collectors.joining("\r\n"));
        }
        catch (Exception e) {
            log.error("Load Start Banner file error", (Throwable)e);
        }
        return this.bannerText;
    }

    public Blade threadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public Blade contextPath(String contextPath) {
        this.environment.set("app.context-path", contextPath);
        return this;
    }

    public WebSocketHandler webSocketHandler() {
        return this.webSocketHandler;
    }

    private void loadConfig(String[] args) {
        String bootConf = this.environment().get("boot_conf", "classpath:application.properties");
        Environment bootEnv = Environment.of(bootConf);
        if (null == bootEnv || bootEnv.isEmpty()) {
            bootEnv = Environment.of("classpath:app.properties");
        }
        if (!Objects.requireNonNull(bootEnv).isEmpty()) {
            Map<String, String> bootEnvMap = bootEnv.toMap();
            Set<Map.Entry<String, String>> entrySet = bootEnvMap.entrySet();
            entrySet.forEach(entry -> this.environment.set((String)entry.getKey(), entry.getValue()));
        }
        String envName = "default";
        Map<String, String> argsMap = BladeKit.parseArgs(args);
        if (StringKit.isNotEmpty(argsMap.get("app.env"))) {
            envName = argsMap.get("app.env");
            String evnFileName = "application-" + envName + ".properties";
            Environment customEnv = Environment.of(evnFileName);
            if (customEnv != null && !customEnv.isEmpty()) {
                customEnv.props().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.environment.set(key.toString(), value)));
            } else {
                evnFileName = "app-" + envName + ".properties";
                customEnv = Environment.of(evnFileName);
                if (customEnv != null && !customEnv.isEmpty()) {
                    customEnv.props().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.environment.set(key.toString(), value)));
                }
            }
        }
        log.info("current environment is: {}", (Object)envName);
        this.register(this.environment);
        if (BladeKit.isEmpty(args)) {
            return;
        }
        if (StringKit.isNotEmpty(argsMap.get("server.address"))) {
            this.environment.set("server.address", argsMap.get("server.address"));
        }
        if (StringKit.isNotEmpty(argsMap.get("server.port"))) {
            this.environment.set("server.port", argsMap.get("server.port"));
        }
    }

    private Blade() {
    }
}

