/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc.bean;

import com.blade.Environment;
import com.blade.ioc.Injector;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueInjector
implements Injector {
    private static final Logger log = LoggerFactory.getLogger(ValueInjector.class);
    private Environment environment;
    private Field target;
    private String key;

    public ValueInjector(Environment environment, Field target, String key) {
        this.environment = environment;
        this.target = target;
        this.key = key;
    }

    @Override
    public void injection(Object bean) {
        try {
            if (!this.key.isEmpty()) {
                Class<Object> clazz = this.target.getType();
                this.target.setAccessible(true);
                Optional<String> value = this.environment.get(this.key);
                if (!value.isPresent()) {
                    log.warn("config is absent,so can't be injected:target is {}", (Object)bean.getClass().getName());
                    return;
                }
                if (value.get().isEmpty()) {
                    log.warn("config is empty,so can't be injected:target is {}", (Object)bean.getClass().getName());
                    return;
                }
                if (clazz.isAssignableFrom(String.class)) {
                    this.target.set(bean, value.isPresent() ? value.get() : "");
                    return;
                }
                String split = this.environment.get("value.split", ",");
                String mapSplit = this.environment.get("value.map.split", ":");
                if (clazz.isAssignableFrom(List.class)) {
                    this.target.set(bean, Arrays.asList(value.get().split(split)));
                    return;
                }
                HashMap map = new HashMap(16);
                if (clazz.isAssignableFrom(Map.class)) {
                    Arrays.stream(value.get().split(split)).filter(d -> d.indexOf(mapSplit) != -1).map(d -> d.split(mapSplit)).forEach(keyValue -> map.put(keyValue[0], keyValue[1]));
                    this.target.set(bean, map);
                    return;
                }
            } else {
                log.warn("key is empty,so can't be injected:target is {}", (Object)bean.getClass().getName());
            }
        }
        catch (IllegalAccessException e) {
            log.error("inject config error! key is {},bean is {}", new Object[]{this.key, bean.getClass().getSimpleName(), e});
        }
    }
}

