/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ExceptionKit {
    public static <T, E extends Exception> Consumer<T> rethrowConsumer(ConsumerWithExceptions<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                ExceptionKit.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> rethrowBiConsumer(BiConsumerWithExceptions<T, U, E> biConsumer) throws E {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                ExceptionKit.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> rethrowFunction(FunctionWithExceptions<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                ExceptionKit.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> rethrowSupplier(SupplierWithExceptions<T, E> function) throws E {
        return () -> {
            try {
                return function.get();
            }
            catch (Exception exception) {
                ExceptionKit.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static void uncheck(RunnableWithExceptions t) {
        try {
            t.run();
        }
        catch (Exception exception) {
            ExceptionKit.throwAsUnchecked(exception);
        }
    }

    public static <R, E extends Exception> R uncheck(SupplierWithExceptions<R, E> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            ExceptionKit.throwAsUnchecked(exception);
            return null;
        }
    }

    public static <T, R, E extends Exception> R uncheck(FunctionWithExceptions<T, R, E> function, T t) {
        try {
            return function.apply(t);
        }
        catch (Exception exception) {
            ExceptionKit.throwAsUnchecked(exception);
            return null;
        }
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    private ExceptionKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface RunnableWithExceptions<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface SupplierWithExceptions<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface FunctionWithExceptions<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface BiConsumerWithExceptions<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ConsumerWithExceptions<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

