/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.StringKit;
import com.blade.kit.Tuple2;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public final class I18nKit {
    private static Map<String, ResourceHolder> CACHE = new ConcurrentHashMap<String, ResourceHolder>();
    private static Pattern pattern = Pattern.compile("_");

    public static synchronized ResourceHolder getInstance(String baseName) {
        return I18nKit.createResourceHolder(baseName, null);
    }

    public static synchronized ResourceHolder getInstance(Locale locale) {
        return I18nKit.createResourceHolder(null, locale);
    }

    private static ResourceHolder createResourceHolder(String baseName, Locale locale) {
        Tuple2<String, Locale> localeModel = I18nKit.toLocaleModel(baseName, locale);
        ResourceHolder holder = CACHE.get(localeModel._1());
        if (null != holder) {
            return holder;
        }
        holder = new ResourceHolder(ResourceBundle.getBundle(localeModel._1(), localeModel._2()));
        CACHE.putIfAbsent(localeModel._1(), holder);
        return holder;
    }

    public static Tuple2<String, Locale> toLocaleModel(String baseName, Locale locale) {
        if (StringKit.isBlank(baseName)) {
            return new Tuple2<String, Locale>("i18n_" + locale.getLanguage() + "_" + locale.getCountry(), locale);
        }
        String[] baseNames = pattern.split(baseName);
        if (baseNames != null && baseNames.length == 3) {
            return new Tuple2<String, Locale>(baseName, new Locale(baseNames[1], baseNames[2]));
        }
        throw new IllegalArgumentException("baseName illegal,name format is :i18n_{language}_{country}.properties,for example:i18n_zh_CN.properties");
    }

    private I18nKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ResourceHolder {
        private ResourceBundle resourceBundle;

        public ResourceHolder(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public String get(String key) {
            return this.resourceBundle.getString(key);
        }

        public Object getObject(String key) {
            return this.resourceBundle.getObject(key);
        }

        public boolean containsKey(String key) {
            return this.resourceBundle.containsKey(key);
        }

        public String format(String key, String ... params) {
            return MessageFormat.format(this.resourceBundle.getString(key), params);
        }
    }
}

