/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.exception.BladeException;
import com.blade.kit.DateKit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectKit {
    private static final Logger log = LoggerFactory.getLogger(ReflectKit.class);
    private static final String TYPE_NAME_PREFIX = "class ";

    public static <T> T newInstance(Type type) {
        try {
            Class<?> clazz = ReflectKit.getClass(type);
            if (clazz == null) {
                return null;
            }
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            log.warn("new instance fail", (Object)e.getMessage());
            return null;
        }
    }

    public static Class<?> getClass(Type type) throws ClassNotFoundException {
        String className = ReflectKit.getClassName(type);
        if (className == null || className.isEmpty()) {
            return null;
        }
        return Class.forName(className);
    }

    public static String getClassName(Type type) {
        if (type == null) {
            return "";
        }
        String className = type.toString();
        if (className.startsWith(TYPE_NAME_PREFIX)) {
            className = className.substring(TYPE_NAME_PREFIX.length());
        }
        return className;
    }

    public static Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        return null;
    }

    public static Object convert(Type type, String value) {
        if (null == value) {
            return value;
        }
        if ("".equals(value)) {
            if (type.equals(String.class)) {
                return value;
            }
            if (type.equals(Integer.TYPE) || type.equals(Double.TYPE) || type.equals(Short.TYPE) || type.equals(Long.TYPE) || type.equals(Byte.TYPE) || type.equals(Float.TYPE)) {
                return 0;
            }
            if (type.equals(Boolean.TYPE)) {
                return false;
            }
            return null;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.parseDouble(value);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.parseLong(value);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return Short.parseShort(value);
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return Byte.parseByte(value);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(value);
        }
        if (type.equals(Date.class)) {
            if (value.length() == 10) {
                return DateKit.toDate(value, "yyyy-MM-dd");
            }
            return DateKit.toDateTime(value, "yyyy-MM-dd HH:mm:ss");
        }
        if (type.equals(LocalDate.class)) {
            return DateKit.toLocalDate(value, "yyyy-MM-dd");
        }
        if (type.equals(LocalDateTime.class)) {
            return DateKit.toLocalDateTime(value, "yyyy-MM-dd HH:mm:ss");
        }
        return value;
    }

    public static Object invokeMethod(Object bean, Method method, Object ... args) throws Exception {
        int argCount;
        Class<?>[] types = method.getParameterTypes();
        int n = argCount = args == null ? 0 : args.length;
        if (argCount != types.length) {
            throw new IllegalStateException(String.format("%s in %s", method.getName(), bean));
        }
        for (int i = 0; i < argCount; ++i) {
            args[i] = ReflectKit.cast(args[i], types[i]);
        }
        return method.invoke(bean, args);
    }

    public static <T> T cast(Object value, Class<T> type) {
        if (null == value) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            if (ReflectKit.is(type, Integer.TYPE, Integer.class)) {
                value = Integer.parseInt(value.toString());
            } else if (ReflectKit.is(type, Long.TYPE, Long.class)) {
                value = Long.parseLong(value.toString());
            } else if (ReflectKit.is(type, Float.TYPE, Float.class)) {
                value = Float.valueOf(Float.parseFloat(value.toString()));
            } else if (ReflectKit.is(type, Double.TYPE, Double.class)) {
                value = Double.parseDouble(value.toString());
            } else if (ReflectKit.is(type, Boolean.TYPE, Boolean.class)) {
                value = Boolean.parseBoolean(value.toString());
            } else if (ReflectKit.is(type, String.class)) {
                value = value.toString();
            }
        }
        return (T)value;
    }

    public static boolean is(Object instance, Object ... maybeValues) {
        if (instance != null && maybeValues != null) {
            for (Object mb : maybeValues) {
                if (!instance.equals(mb)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasInterface(Class<?> cls, Class<?> inter) {
        return Stream.of(cls.getInterfaces()).anyMatch(c -> c.equals(inter));
    }

    public static boolean isNormalClass(Class<?> cls) {
        return !cls.isInterface() && !Modifier.isAbstract(cls.getModifiers());
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ... types) {
        try {
            return cls.getMethod(methodName, types);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setFieldValue(Field field, Object target, Object value) {
        field.setAccessible(true);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new BladeException(500, "", e.getMessage());
        }
    }

    public static boolean isPrimitive(Object bean) {
        return ReflectKit.isPrimitive(bean.getClass());
    }

    public static boolean isPrimitive(Type type) {
        return type.equals(Boolean.TYPE) || type.equals(Double.TYPE) || type.equals(Float.TYPE) || type.equals(Short.TYPE) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Byte.TYPE) || type.equals(Character.TYPE);
    }

    public static boolean isBasicType(Object bean) {
        return ReflectKit.isBasicType(bean.getClass());
    }

    public static boolean isBasicType(Type type) {
        return type.equals(String.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(Short.class) || type.equals(Boolean.class) || type.equals(Byte.class) || type.equals(Character.class) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Double.TYPE) || type.equals(Float.TYPE) || type.equals(Short.TYPE) || type.equals(Boolean.TYPE) || type.equals(Byte.TYPE) || type.equals(Character.TYPE);
    }

    public static boolean isArray(Type type) {
        return type == String[].class || type == int[].class || type == Integer[].class || type == Long[].class || type == Double[].class || type == double[].class || type == Float[].class || type == float[].class || type == Boolean[].class || type == boolean[].class || type == Short[].class || type == short[].class || type == Byte[].class || type == byte[].class;
    }

    public static Class<?> form(String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (Exception e) {
            log.warn("Class.forName fail", (Object)e.getMessage());
            return null;
        }
    }

    public static List<Field> loopFields(Class<?> type) {
        Class<?> superCls = type.getSuperclass();
        if (superCls.equals(Object.class)) {
            if (null != type.getDeclaredFields() && type.getDeclaredFields().length > 0) {
                return Arrays.asList(type.getDeclaredFields());
            }
            return new ArrayList<Field>();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (null != type.getDeclaredFields() && type.getDeclaredFields().length > 0) {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
        }
        while (!superCls.equals(Object.class)) {
            if (null != superCls.getDeclaredFields() && superCls.getDeclaredFields().length > 0) {
                fields.addAll(Arrays.asList(superCls.getDeclaredFields()));
            }
            superCls = superCls.getSuperclass();
        }
        return fields;
    }

    private ReflectKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

