/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit.json;

public class ParseException
extends RuntimeException {
    private int position = 0;
    private String json = "";

    public ParseException(String json, int position, String message) {
        super(message);
        this.json = json;
        this.position = position;
    }

    @Override
    public String getMessage() {
        int maxTipLength = 10;
        int end = this.position + 1;
        int start = end - 10;
        if (start < 0) {
            start = 0;
        }
        if (end > this.json.length()) {
            end = this.json.length();
        }
        return String.format("%s  (%d):%s", this.json.substring(start, end), this.position, super.getMessage());
    }

    public String getJson() {
        return this.json;
    }

    public int getPosition() {
        return this.position;
    }
}

