/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc;

import com.blade.Blade;
import com.blade.Environment;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.session.SessionManager;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.Optional;

public class WebContext {
    private static final FastThreadLocal<WebContext> fastThreadLocal = new FastThreadLocal();
    private static Blade blade;
    private static String contextPath;
    private Request request;
    private Response response;

    public WebContext(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public static void set(WebContext webContext) {
        fastThreadLocal.set((Object)webContext);
    }

    public static WebContext get() {
        return (WebContext)fastThreadLocal.get();
    }

    public static void remove() {
        fastThreadLocal.remove();
    }

    public static Request request() {
        WebContext webContext = WebContext.get();
        return null != webContext ? webContext.request : null;
    }

    public static Response response() {
        WebContext webContext = WebContext.get();
        return null != webContext ? webContext.response : null;
    }

    public static void init(Blade blade, String contextPath) {
        WebContext.blade = blade;
        WebContext.contextPath = contextPath;
    }

    public static Blade blade() {
        return blade;
    }

    public static SessionManager sessionManager() {
        return null != WebContext.blade() ? WebContext.blade().sessionManager() : null;
    }

    public static String contextPath() {
        return contextPath;
    }

    public static void clean() {
        fastThreadLocal.remove();
        blade = null;
    }

    public Environment environment() {
        return WebContext.blade().environment();
    }

    public Optional<String> env(String key) {
        return WebContext.blade().env(key);
    }

    public String env(String key, String defaultValue) {
        return WebContext.blade().env(key, defaultValue);
    }
}

