/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.handler;

import com.blade.Blade;
import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.kit.UUID;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Session;
import com.blade.mvc.http.session.SessionManager;
import java.time.Instant;

public class SessionHandler {
    private final Blade blade;
    private final SessionManager sessionManager;
    private final String sessionKey;
    private final int timeout;

    public SessionHandler(Blade blade) {
        this.blade = blade;
        this.sessionManager = blade.sessionManager();
        this.sessionKey = blade.environment().get("http.session.key", "SESSION");
        this.timeout = blade.environment().getInt("http.session.timeout", 1800);
    }

    public Session createSession(Request request) {
        Session session = this.getSession(request);
        long now = Instant.now().getEpochSecond();
        if (null == session) {
            long expired = now + (long)this.timeout;
            session = (Session)ReflectKit.newInstance(this.blade.sessionType());
            session.id(UUID.UU32());
            session.created(now);
            session.expired(expired);
            this.sessionManager.createSession(session);
            return session;
        }
        if (session.expired() < now) {
            this.sessionManager.destorySession(session);
        } else {
            long expired = now + (long)this.timeout;
            session.expired(expired);
        }
        return session;
    }

    private Session getSession(Request request) {
        String cookieHeader = request.cookie(this.sessionKey);
        if (StringKit.isEmpty(cookieHeader)) {
            return null;
        }
        return this.sessionManager.getSession(cookieHeader);
    }
}

