/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http.session;

import com.blade.mvc.http.Session;
import com.blade.mvc.http.session.SessionManager;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCleaner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SessionCleaner.class);
    private SessionManager sessionManager;

    public SessionCleaner(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Collection<Session> sessions = this.sessionManager.sessionMap().values();
                sessions.parallelStream().filter(this::expires).forEach(this.sessionManager::destorySession);
                continue;
            }
            catch (Exception e) {
                log.error("Session clean error", (Throwable)e);
                continue;
            }
            finally {
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e) {
                    log.error("Session cleaner interrupted", (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private boolean expires(Session session) {
        long now = Instant.now().getEpochSecond();
        return session.expired() < now;
    }
}

