/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.auth;

import com.blade.kit.StringKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.hook.WebHook;
import com.blade.security.web.auth.AuthOption;
import com.blade.security.web.auth.AuthPair;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthMiddleware
implements WebHook {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthMiddleware.class);
    private String realm;
    private List<AuthPair> authPairs = new ArrayList<AuthPair>();
    private Set<String> urlStartExclusions;

    public BasicAuthMiddleware(AuthOption authOption) {
        this.urlStartExclusions = authOption.getUrlStartExclusions();
        this.realm = "Basic realm=\"" + authOption.getRealm() + "\"";
        authOption.getAccounts().forEach((user, pass) -> this.authPairs.add(new AuthPair((String)user, this.authorizationHeader((String)user, (String)pass))));
    }

    private String authorizationHeader(String user, String password) {
        String base = user + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(base.getBytes(StandardCharsets.UTF_8));
    }

    private String searchCredential(String authValue) {
        if (StringKit.isEmpty(authValue)) {
            return null;
        }
        return this.authPairs.stream().filter(authPair -> authPair.getValue().equals(authValue)).map(AuthPair::getUser).findFirst().orElse(null);
    }

    @Override
    public boolean before(RouteContext context) {
        boolean isAuth = false;
        for (String startExclusion : this.urlStartExclusions) {
            if (!"/".equals(startExclusion) && !context.uri().startsWith(startExclusion)) continue;
            isAuth = true;
            break;
        }
        if (!isAuth) {
            return true;
        }
        String authorization = context.header("Authorization");
        String user = this.searchCredential(authorization);
        if (null == user) {
            context.header("WWW-Authenticate", this.realm).status(401);
            return false;
        }
        return true;
    }
}

